/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.server.undertow;

import com.jfinal.config.JFinalConfig;
import com.jfinal.server.undertow.IpKit;
import com.jfinal.server.undertow.PropExt;
import com.jfinal.server.undertow.UndertowConfig;
import com.jfinal.server.undertow.UndertowKit;
import com.jfinal.server.undertow.WebBuilder;
import com.jfinal.server.undertow.handler.HttpToHttpsHandler;
import com.jfinal.server.undertow.hotswap.HotSwapWatcher;
import com.jfinal.server.undertow.session.HotSwapSessionManagerFactory;
import com.jfinal.server.undertow.session.HotSwapSessionPersistenceManager;
import com.jfinal.server.undertow.ssl.SslBuilder;
import io.undertow.Handlers;
import io.undertow.Undertow;
import io.undertow.UndertowOptions;
import io.undertow.Version;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.PathHandler;
import io.undertow.server.handlers.SetHeaderHandler;
import io.undertow.server.handlers.encoding.ContentEncodingProvider;
import io.undertow.server.handlers.encoding.ContentEncodingRepository;
import io.undertow.server.handlers.encoding.EncodingHandler;
import io.undertow.server.handlers.encoding.GzipEncodingProvider;
import io.undertow.servlet.Servlets;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.DeploymentManager;
import io.undertow.servlet.api.SessionManagerFactory;
import io.undertow.servlet.api.SessionPersistenceManager;
import java.text.DecimalFormat;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.ServletException;

public class UndertowServer {
    public String version = "3.6";
    protected UndertowConfig config;
    protected DeploymentInfo deploymentInfo;
    protected DeploymentManager deploymentManager;
    protected Undertow.Builder builder;
    protected Undertow undertow;
    protected volatile boolean started = false;
    protected volatile HotSwapWatcher hotSwapWatcher;
    protected DecimalFormat decimalFormat = new DecimalFormat("#.#");
    protected Consumer<WebBuilder> webBuilder;
    protected Consumer<UndertowConfig> configConsumer;
    protected BiConsumer<ClassLoader, DeploymentInfo> onDeployConsumer;
    protected Consumer<Undertow.Builder> onStartConsumer;

    public static void start(Class<? extends JFinalConfig> jfinalConfigClass) {
        UndertowServer.create(jfinalConfigClass).start();
    }

    public static void start(String jfinalConfigClass) {
        UndertowServer.create(jfinalConfigClass).start();
    }

    public static void start(Class<? extends JFinalConfig> jfinalConfigClass, int port, boolean devMode) {
        UndertowServer.create(jfinalConfigClass).setPort(port).setDevMode(devMode).start();
    }

    public static void start(String jfinalConfigClass, int port, boolean devMode) {
        UndertowServer.create(jfinalConfigClass).setPort(port).setDevMode(devMode).start();
    }

    public static UndertowServer create(Class<? extends JFinalConfig> jfinalConfigClass) {
        return new UndertowServer(new UndertowConfig(jfinalConfigClass));
    }

    public static UndertowServer create(String jfinalConfigClass) {
        return new UndertowServer(new UndertowConfig(jfinalConfigClass));
    }

    public static UndertowServer create(Class<? extends JFinalConfig> jfinalConfigClass, String undertowConfig) {
        return new UndertowServer(new UndertowConfig(jfinalConfigClass, undertowConfig));
    }

    public static UndertowServer create(String jfinalConfigClass, String undertowConfig) {
        return new UndertowServer(new UndertowConfig(jfinalConfigClass, undertowConfig));
    }

    public static UndertowServer create(UndertowConfig undertowConfig) {
        return new UndertowServer(undertowConfig);
    }

    protected UndertowServer(UndertowConfig undertowConfig) {
        this.config = undertowConfig;
    }

    public synchronized void start() {
        if (this.configConsumer != null) {
            this.configConsumer.accept(this.config);
            this.configConsumer = null;
        }
        this.loadCommandLineParameter();
        try {
            System.out.println("Starting JFinal " + UndertowKit.getJFinalVersion());
            System.out.println("Info: jfinal-undertow " + this.version + ", undertow " + Version.getVersionString() + ", jvm " + System.getProperty("java.version"));
            long start = System.currentTimeMillis();
            this.doStart();
            System.out.println("Starting Complete in " + this.getTimeSpent(start) + " seconds. Welcome To The JFinal World (^_^)\n");
            this.printUrl();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    UndertowServer.this.stop();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            this.stopSilently();
            System.exit(1);
        }
    }

    protected void printUrl() {
        String msg = "Server running on:\n";
        msg = msg + " > Local:   http://localhost:" + this.config.getPort() + this.getContextPathInfo();
        if (this.config.isSslEnable()) {
            msg = msg + "   https://localhost:" + this.config.getSslConfig().getPort() + this.getContextPathInfo();
        }
        msg = msg + "\n";
        List<String> ipList = IpKit.getLocalIp();
        for (String ip : ipList) {
            msg = msg + " > Network: http://" + ip + ":" + this.config.getPort() + this.getContextPathInfo();
            if (this.config.isSslEnable()) {
                msg = msg + "   https://" + ip + ":" + this.config.getSslConfig().getPort() + this.getContextPathInfo();
            }
            msg = msg + "\n";
        }
        System.out.println(msg);
    }

    protected String getContextPathInfo() {
        return "/".equals(this.config.getContextPath()) ? "" : this.config.getContextPath();
    }

    protected void loadCommandLineParameter() {
        String port = System.getProperty("undertow.port");
        String host = System.getProperty("undertow.host");
        String resourcePath = System.getProperty("undertow.resourcePath");
        String ioThreads = System.getProperty("undertow.ioThreads");
        String workerThreads = System.getProperty("undertow.workerThreads");
        if (this.notBlank(port)) {
            this.config.port = Integer.parseInt(port.trim());
        }
        if (this.notBlank(host)) {
            this.config.host = host.trim();
        }
        if (this.notBlank(resourcePath)) {
            this.config.resourcePath = resourcePath.trim();
        }
        if (this.notBlank(ioThreads)) {
            this.config.ioThreads = Integer.parseInt(ioThreads.trim());
        }
        if (this.notBlank(workerThreads)) {
            this.config.workerThreads = Integer.parseInt(workerThreads.trim());
        }
    }

    protected boolean notBlank(String str) {
        return str != null && !"".equals(str.trim());
    }

    protected void doStart() {
        if (this.started) {
            return;
        }
        if (UndertowKit.isDeployMode()) {
            UndertowConfig.devMode = false;
        }
        this.init();
        if (this.onDeployConsumer != null) {
            this.onDeployConsumer.accept(this.config.getClassLoader(), this.deploymentInfo);
        }
        if (UndertowKit.notAvailablePort(this.config.getPort())) {
            throw new IllegalStateException("port: " + this.config.getPort() + " not available!\n");
        }
        this.deploymentManager = Servlets.defaultContainer().addDeployment(this.deploymentInfo);
        this.deploymentManager.deploy();
        this.configHttp();
        if (this.onStartConsumer != null) {
            this.onStartConsumer.accept(this.builder);
        }
        this.undertow = this.builder.build();
        this.undertow.start();
        if (this.isDevMode() && this.hotSwapWatcher == null) {
            this.hotSwapWatcher = new HotSwapWatcher(this);
            this.hotSwapWatcher.start();
        }
        this.started = true;
    }

    protected void configHttp() {
        HttpHandler httpHandler = null;
        try {
            httpHandler = this.deploymentManager.start();
        }
        catch (ServletException e) {
            this.stopSilently();
            throw new RuntimeException(e);
        }
        PathHandler pathHandler = Handlers.path().addPrefixPath(this.config.getContextPath(), httpHandler);
        pathHandler = this.configHandler((HttpHandler)pathHandler);
        pathHandler = this.configGzip((HttpHandler)pathHandler);
        pathHandler = this.configServerName((HttpHandler)pathHandler);
        pathHandler = this.configSsl((HttpHandler)pathHandler);
        if (!this.config.isSslEnable() || !this.config.isHttpDisable()) {
            this.builder.addHttpListener(this.config.getPort(), this.config.getHost());
        }
        this.builder.setHandler((HttpHandler)pathHandler);
    }

    protected HttpHandler configSsl(HttpHandler httpHandler) {
        if (this.config.isSslEnable()) {
            new SslBuilder(this.builder, this.config).build();
            if (this.config.isHttpToHttps()) {
                httpHandler = new HttpToHttpsHandler(httpHandler, this.config);
            }
        } else if (this.config.isHttpToHttps()) {
            System.err.println("http redirect to https needs ssl support");
        }
        return httpHandler;
    }

    protected HttpHandler configHandler(HttpHandler next) {
        return next;
    }

    protected HttpHandler configGzip(HttpHandler pathHandler) {
        if (this.config.isGzipEnable()) {
            ContentEncodingRepository repository = new ContentEncodingRepository();
            GzipEncodingProvider provider = new GzipEncodingProvider(this.config.getGzipLevel());
            int minLength = this.config.getGzipMinLength();
            Predicate predicate = minLength > 0 ? Predicates.requestLargerThan((long)minLength) : Predicates.truePredicate();
            repository.addEncodingHandler("gzip", (ContentEncodingProvider)provider, 100, predicate);
            return new EncodingHandler(pathHandler, repository);
        }
        return pathHandler;
    }

    protected HttpHandler configServerName(HttpHandler pathHandler) {
        String serverName = this.config.getServerName();
        if (serverName != null) {
            return new SetHeaderHandler(pathHandler, "Server", serverName);
        }
        return pathHandler;
    }

    protected void init() {
        this.builder = Undertow.builder();
        this.configJFinalPathKit();
        this.configUndertow();
        this.configWeb();
        this.configJFinalFilter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void stop() {
        if (!this.started) {
            return;
        }
        this.started = false;
        System.out.println("\nShutdown Undertow Server ......");
        long start = System.currentTimeMillis();
        try {
            if (this.hotSwapWatcher != null) {
                this.hotSwapWatcher.exit();
            }
            this.doStop();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.stopSilently();
        }
        finally {
            System.out.println("Shutdown Complete in " + this.getTimeSpent(start) + " seconds. See you later (^_^)\n");
        }
    }

    protected void doStop() throws ServletException {
        this.deploymentManager.stop();
        this.undertow.stop();
    }

    public synchronized void restart() {
        if (!this.started) {
            return;
        }
        this.started = false;
        try {
            System.err.println("\nLoading changes ......");
            long start = System.currentTimeMillis();
            this.doStop();
            this.config.replaceClassLoader();
            this.doStart();
            System.err.println("Loading complete in " + this.getTimeSpent(start) + " seconds (^_^)\n");
        }
        catch (Exception e) {
            System.err.println("Error restarting webapp after change in watched files");
            e.printStackTrace();
        }
    }

    protected String getTimeSpent(long startTime) {
        float timeSpent = (float)(System.currentTimeMillis() - startTime) / 1000.0f;
        return this.decimalFormat.format(timeSpent);
    }

    protected void stopSilently() {
        try {
            this.started = false;
            if (this.undertow != null) {
                this.undertow.stop();
            }
        }
        catch (Exception e) {
            UndertowKit.doNothing(e);
        }
    }

    public UndertowServer config(Consumer<UndertowConfig> configConsumer) {
        this.configConsumer = configConsumer;
        return this;
    }

    public UndertowServer onDeploy(BiConsumer<ClassLoader, DeploymentInfo> onDeployConsumer) {
        this.onDeployConsumer = onDeployConsumer;
        return this;
    }

    public UndertowServer onStart(Consumer<Undertow.Builder> onStartConsumer) {
        this.onStartConsumer = onStartConsumer;
        return this;
    }

    protected void configJFinalPathKit() {
        if (UndertowKit.isDeployMode()) {
            UndertowKit.configJFinalPathKit(this.config);
            return;
        }
    }

    protected void configUndertow() {
        this.builder.setServerOption(UndertowOptions.ALLOW_UNESCAPED_CHARACTERS_IN_URL, (Object)true);
        if (this.config.isSslEnable() && this.config.getHttp2Enable() != null && this.config.getHttp2Enable().booleanValue()) {
            this.builder.setServerOption(UndertowOptions.ENABLE_HTTP2, (Object)true);
        }
        if (this.config.getIoThreads() != null) {
            this.builder.setIoThreads(this.config.getIoThreads().intValue());
        }
        if (this.config.getWorkerThreads() != null) {
            this.builder.setWorkerThreads(this.config.getWorkerThreads().intValue());
        }
        if (this.config.getBufferSize() != null) {
            this.builder.setBufferSize(this.config.getBufferSize().intValue());
        }
        if (this.config.getDirectBuffers() != null) {
            this.builder.setDirectBuffers(this.config.getDirectBuffers().booleanValue());
        }
        this.deploymentInfo = Servlets.deployment();
        this.configSessionPersistenceManager();
        DeploymentInfo di = this.deploymentInfo;
        di.setResourceManager(this.config.getResourceManager());
        di.setClassLoader(this.config.getClassLoader());
        di.setContextPath(this.config.getContextPath());
        di.setDeploymentName("jfinal");
        di.setEagerFilterInit(true);
        if (this.config.getSessionTimeout() != null) {
            di.setDefaultSessionTimeout(this.config.getSessionTimeout().intValue());
        }
    }

    protected void configJFinalFilter() {
        this.deploymentInfo.addFilter(Servlets.filter((String)"jfinal", this.getJFinalFilter()).addInitParam("configClass", this.config.getJFinalConfig())).addFilterUrlMapping("jfinal", "/*", DispatcherType.REQUEST);
    }

    private Class<? extends Filter> getJFinalFilter() {
        try {
            return this.config.getClassLoader().loadClass("com.jfinal.core.JFinalFilter");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected void configWeb() {
        if (this.webBuilder != null) {
            WebBuilder wb = new WebBuilder(this);
            this.webBuilder.accept(wb);
            if (wb.webSocketConfig != null) {
                wb.webSocketConfig.configWebSocket(this.deploymentInfo);
            }
        }
    }

    public UndertowServer configWeb(Consumer<WebBuilder> webBuilder) {
        this.webBuilder = webBuilder;
        return this;
    }

    protected void configSessionPersistenceManager() {
        if (this.config.getSessionHotSwap() && this.isDevMode()) {
            this.deploymentInfo.setSessionPersistenceManager((SessionPersistenceManager)new HotSwapSessionPersistenceManager(this.config));
            this.deploymentInfo.setSessionManagerFactory((SessionManagerFactory)HotSwapSessionManagerFactory.me);
        }
    }

    public UndertowConfig getUndertowConfig() {
        return this.config;
    }

    public UndertowServer setHost(String host) {
        this.config.setHost(host);
        return this;
    }

    public UndertowServer setPort(int port) {
        this.config.setPort(port);
        return this;
    }

    public UndertowServer setGzipEnable(boolean gzipEnable) {
        this.config.setGzipEnable(gzipEnable);
        return this;
    }

    public UndertowServer setContextPath(String contextPath) {
        this.config.setContextPath(contextPath);
        return this;
    }

    public UndertowServer setResourcePath(String resourcePath) {
        this.config.setResourcePath(resourcePath);
        return this;
    }

    public UndertowServer setDevMode(boolean devMode) {
        this.config.setDevMode(devMode);
        return this;
    }

    public boolean isDevMode() {
        return UndertowConfig.isDevMode();
    }

    public boolean isStarted() {
        return this.started;
    }

    public UndertowServer addHotSwapClassPrefix(String prefix) {
        this.config.addHotSwapClassPrefix(prefix);
        return this;
    }

    public UndertowServer addSystemClassPrefix(String prefix) {
        this.config.addSystemClassPrefix(prefix);
        return this;
    }

    public static void main(String[] args) {
        String undertowConfig = args == null || args.length == 0 ? "undertow.txt" : args[0];
        PropExt p = new PropExt(undertowConfig = undertowConfig.trim());
        String configClass = p.get("configClass");
        if (configClass == null) {
            throw new RuntimeException("configClass must config in file : " + undertowConfig);
        }
        UndertowServer.create(configClass.trim(), undertowConfig).start();
    }
}

