/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.weixin.sdk.api;

import com.jfinal.weixin.sdk.api.AccessTokenApi;
import com.jfinal.weixin.sdk.api.ApiResult;
import com.jfinal.weixin.sdk.utils.HttpUtils;
import com.jfinal.weixin.sdk.utils.JsonUtils;
import java.util.HashMap;

public class FreePublishApi {
    public static final String API_PREFIX = "https://api.weixin.qq.com/cgi-bin/freepublish/";

    public static ApiResult submit(String mediaId) {
        String url = "https://api.weixin.qq.com/cgi-bin/freepublish/submit?access_token=" + AccessTokenApi.getAccessTokenStr();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("media_id", mediaId);
        String jsonResult = HttpUtils.post(url, JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }

    public static ApiResult get(String publishId) {
        String url = "https://api.weixin.qq.com/cgi-bin/freepublish/get?access_token=" + AccessTokenApi.getAccessTokenStr();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("publish_id", publishId);
        String jsonResult = HttpUtils.post(url, JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }

    public static ApiResult delete(String articleId, int index) {
        String url = "https://api.weixin.qq.com/cgi-bin/freepublish/delete?access_token=" + AccessTokenApi.getAccessTokenStr();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("article_id", articleId);
        data.put("index", index);
        String jsonResult = HttpUtils.post(url, JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }

    public static ApiResult getArticle(String articleId) {
        String url = "https://api.weixin.qq.com/cgi-bin/freepublish/getarticle?access_token=" + AccessTokenApi.getAccessTokenStr();
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("article_id", articleId);
        String jsonResult = HttpUtils.post(url, JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }

    public static ApiResult getBatch(int offset, int count) {
        return FreePublishApi.getBatch(offset, count, false);
    }

    public static ApiResult getBatch(int offset, int count, boolean noContent) {
        String url = "https://api.weixin.qq.com/cgi-bin/freepublish/batchget?access_token=" + AccessTokenApi.getAccessTokenStr();
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        data.put("offset", offset);
        data.put("count", count);
        data.put("no_content", noContent ? 1 : 0);
        String jsonResult = HttpUtils.post(url, JsonUtils.toJson(data));
        return new ApiResult(jsonResult);
    }
}

