/*
 * Decompiled with CFR 0.152.
 */
package com.jfinal.wxaapp.jfinal;

import com.jfinal.aop.Interceptor;
import com.jfinal.aop.Invocation;
import com.jfinal.core.Controller;
import com.jfinal.kit.StrKit;
import com.jfinal.log.Log;
import com.jfinal.weixin.sdk.jfinal.AppIdParser;
import com.jfinal.weixin.sdk.kit.SignatureCheckKit;
import com.jfinal.wxaapp.WxaConfig;
import com.jfinal.wxaapp.WxaConfigKit;
import com.jfinal.wxaapp.jfinal.WxaMsgController;

public class WxaMsgInterceptor
implements Interceptor {
    private static final Log log = Log.getLog(WxaMsgInterceptor.class);
    private static AppIdParser _parser = new AppIdParser.DefaultParameterAppIdParser();

    public static void setAppIdParser(AppIdParser parser) {
        _parser = parser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void intercept(Invocation inv) {
        Controller controller = inv.getController();
        if (!(controller instanceof WxaMsgController)) {
            throw new RuntimeException("\u63a7\u5236\u5668\u9700\u8981\u7ee7\u627f WxaMsgController");
        }
        try {
            String appId = _parser.getAppId(controller);
            WxaConfigKit.setThreadLocalAppId(appId);
            WxaConfig wxaConfig = WxaConfigKit.getWxaConfig();
            String token = wxaConfig.getToken();
            if (this.isConfigServerRequest(controller)) {
                this.configServer(controller, token);
                return;
            }
            if (WxaConfigKit.isDevMode()) {
                inv.invoke();
            } else if (this.checkSignature(controller, token)) {
                inv.invoke();
            } else {
                controller.renderText("\u7b7e\u540d\u9a8c\u8bc1\u5931\u8d25\uff0c\u8bf7\u786e\u5b9a\u662f\u5fae\u4fe1\u670d\u52a1\u5668\u5728\u53d1\u9001\u6d88\u606f\u8fc7\u6765");
            }
        }
        finally {
            WxaConfigKit.removeThreadLocalAppId();
        }
    }

    private boolean checkSignature(Controller controller, String token) {
        String signature = controller.getPara("signature");
        String timestamp = controller.getPara("timestamp");
        String nonce = controller.getPara("nonce");
        if (StrKit.isBlank((String)signature) || StrKit.isBlank((String)timestamp) || StrKit.isBlank((String)nonce)) {
            controller.renderText("check signature failure");
            return false;
        }
        if (SignatureCheckKit.me.checkSignature(signature, token, timestamp, nonce)) {
            return true;
        }
        log.error("check signature failure:  signature = " + controller.getPara("signature") + " timestamp = " + controller.getPara("timestamp") + " nonce = " + controller.getPara("nonce"));
        return false;
    }

    private boolean isConfigServerRequest(Controller controller) {
        return StrKit.notBlank((String)controller.getPara("echostr"));
    }

    public void configServer(Controller c, String token) {
        String nonce;
        String timestamp;
        String echostr = c.getPara("echostr");
        String signature = c.getPara("signature");
        boolean isOk = SignatureCheckKit.me.checkSignature(signature, token, timestamp = c.getPara("timestamp"), nonce = c.getPara("nonce"));
        if (isOk) {
            c.renderText(echostr);
        } else {
            log.error("\u9a8c\u8bc1\u5931\u8d25\uff1aconfigServer");
        }
    }
}

