/*
 * Decompiled with CFR 0.152.
 */
package com.jthinking.common.util.ip;

import com.jthinking.common.util.ip.CustomIPInfo;
import com.jthinking.common.util.ip.IPInfo;
import com.jthinking.common.util.ip.IPv4InfoUtils;
import com.jthinking.common.util.ip.IPv6InfoUtils;
import com.jthinking.common.util.ip.IpUtils;
import java.math.BigInteger;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class IPInfoUtils {
    private static final IPInfo UNKNOWN = new IPInfo("\u672a\u77e5", "\u672a\u77e5", "\u672a\u77e5", "\u672a\u77e5", false, 0.0, 0.0);
    private static volatile boolean useCustomFlag = false;
    private static final Map<BigInteger, CustomIPInfo> CUSTOM_IP_INFO_LIST = new ConcurrentHashMap<BigInteger, CustomIPInfo>();
    public static final Map<String, String> COUNTRY_GEO = new HashMap<String, String>(){
        {
            this.put("\u4e0d\u4e39", "27.466089,89.641907");
            this.put("\u4e1c\u5e1d\u6c76", "-8.55861,125.573608");
            this.put("\u4e2d\u975e\u5171\u548c\u56fd", "5.02666,21.208759");
            this.put("\u4e39\u9ea6", "55.675941,12.56553");
            this.put("\u4e4c\u514b\u5170", "50.433334,30.516666");
            this.put("\u4e4c\u5179\u522b\u514b\u65af\u5766", "41.264648,69.21627");
            this.put("\u4e4c\u5e72\u8fbe", "3.37786,31.790899");
            this.put("\u4e4c\u62c9\u572d", "-34.200001,-54.75");
            this.put("\u4e4d\u5f97", "13.82916,20.832399");
            this.put("\u4e5f\u95e8", "15.35472,44.206669");
            this.put("\u4e9a\u7f8e\u5c3c\u4e9a", "40.18111,44.513611");
            this.put("\u4ee5\u8272\u5217", "31.769039,35.216331");
            this.put("\u4f0a\u62c9\u514b", "33.34058,44.400879");
            this.put("\u4f0a\u6717", "35.694389,51.421509");
            this.put("\u4f2f\u5229\u5179", "17.25,-88.76667");
            this.put("\u4f5b\u5f97\u89d2", "15.1,-23.683331");
            this.put("\u4fc4\u7f57\u65af", "55.75222,37.615555");
            this.put("\u4fdd\u52a0\u5229\u4e9a", "42.69751,23.32415");
            this.put("\u514b\u7f57\u5730\u4e9a", "45.22472,18.73806");
            this.put("\u5173\u5c9b", "13.46559,144.747955");
            this.put("\u5188\u6bd4\u4e9a", "13.40417,-16.65583");
            this.put("\u51b0\u5c9b", "64.135483,-21.895411");
            this.put("\u51e0\u5185\u4e9a", "8.68333,-8.63333");
            this.put("\u51e0\u5185\u4e9a\u6bd4\u7ecd", "12.16667,-14.66667");
            this.put("\u5217\u652f\u6566\u58eb\u767b", "47.14151,9.52154");
            this.put("\u521a\u679c", "2.73877,23.78326");
            this.put("\u521a\u679c\u5171\u548c\u56fd", "-4.32459,15.32146");
            this.put("\u521a\u679c\u6c11\u4e3b\u5171\u548c\u56fd", "1.2,19.8");
            this.put("\u5229\u6bd4\u4e9a", "32.375351,15.09254");
            this.put("\u5229\u6bd4\u91cc\u4e9a", "4.67972,-8.23389");
            this.put("\u52a0\u62ff\u5927", "45.411171,-75.69812");
            this.put("\u52a0\u7eb3", "5.3617,-1.94732");
            this.put("\u52a0\u84ec", "2.07597,11.50065");
            this.put("\u5308\u7259\u5229", "47.498009,19.039909");
            this.put("\u5317\u9a6c\u91cc\u4e9a\u90a3\u7fa4\u5c9b", "14.96874,145.624374");
            this.put("\u5357\u4e54\u6cbb\u4e9a\u5c9b\u4e0e\u5357\u6851\u5a01\u5947\u7fa4\u5c9b", "-54.281109,-36.509201");
            this.put("\u5357\u82cf\u4e39", "8.76816,27.40019");
            this.put("\u5357\u975e", "-25.74486,28.18783");
            this.put("\u535a\u5948\u5c14\u5c9b", "12.16667,-68.26667");
            this.put("\u535a\u8328\u74e6\u7eb3", "-24.450001,26.01667");
            this.put("\u5361\u5854\u5c14", "25.286667,51.533333");
            this.put("\u5362\u65fa\u8fbe", "-2.59667,29.739441");
            this.put("\u5362\u68ee\u5821", "49.611671,6.13");
            this.put("\u5370\u5ea6", "28.666668,77.216667");
            this.put("\u5370\u5ea6\u5c3c\u897f\u4e9a", "-6.21462,106.845131");
            this.put("\u5371\u5730\u9a6c\u62c9", "14.64072,-90.513268");
            this.put("\u5384\u74dc\u591a\u5c14", "-2.2,-78.833328");
            this.put("\u5384\u7acb\u7279\u91cc\u4e9a", "14.84444,39.37722");
            this.put("\u53d9\u5229\u4e9a", "33.510201,36.291279");
            this.put("\u53e4\u5df4", "20.024719,-75.821938");
            this.put("\u5409\u5c14\u5409\u65af\u65af\u5766", "42.869999,74.589996");
            this.put("\u5409\u5e03\u63d0", "11.15583,42.712502");
            this.put("\u54c8\u8428\u514b\u65af\u5766", "51.180099,71.445976");
            this.put("\u54e5\u4f26\u6bd4\u4e9a", "3.43722,-76.522499");
            this.put("\u54e5\u65af\u8fbe\u9ece\u52a0", "10.01667,-84.216667");
            this.put("\u5580\u9ea6\u9686", "3.98333,13.18333");
            this.put("\u56fe\u74e6\u5362", "-6.28764,176.31472");
            this.put("\u571f\u5e93\u66fc\u65af\u5766", "37.950001,58.383331");
            this.put("\u571f\u8033\u5176", "39.919868,32.854271");
            this.put("\u5723\u5362\u897f\u4e9a", "14.01667,-60.966671");
            this.put("\u5723\u57fa\u8328\u548c\u5c3c\u7ef4\u65af", "17.29484,-62.726101");
            this.put("\u5723\u591a\u7f8e\u548c\u666e\u6797\u897f\u6bd4", "0.33654,6.72732");
            this.put("\u5723\u5df4\u6258\u6d1b\u7f2a\u5c9b", "17.896179,-62.849781");
            this.put("\u5723\u6587\u68ee\u7279\u548c\u683c\u6797\u7eb3\u4e01\u65af", "13.15872,-61.224751");
            this.put("\u5723\u76ae\u57c3\u5c14\u548c\u5bc6\u514b\u9686", "50.088039,14.42076");
            this.put("\u5723\u8bde\u5c9b", "-10.42172,105.679123");
            this.put("\u5723\u8d6b\u52d2\u62ff\u5c9b", "-15.93872,-5.71675");
            this.put("\u5723\u9a6c\u529b\u8bfa", "43.933331,12.45");
            this.put("\u572d\u4e9a\u90a3", "7.26439,-58.50769");
            this.put("\u5766\u6851\u5c3c\u4e9a", "-6.82349,39.269508");
            this.put("\u57c3\u53ca", "29.973709,32.526272");
            this.put("\u57c3\u585e\u4fc4\u6bd4\u4e9a", "9.59306,41.866112");
            this.put("\u57fa\u91cc\u5df4\u65af", "1.3673,173.124146");
            this.put("\u5854\u5409\u514b\u65af\u5766", "38.535751,68.779053");
            this.put("\u585e\u5185\u52a0\u5c14", "12.81028,-16.226391");
            this.put("\u585e\u5c14\u7ef4\u4e9a", "44.804008,20.46513");
            this.put("\u585e\u62c9\u5229\u6602", "9.16667,-11.4");
            this.put("\u585e\u6d66\u8def\u65af", "35.166672,33.366669");
            this.put("\u585e\u73ed\u5c9b", "15.21233,145.754501");
            this.put("\u585e\u820c\u5c14", "-4.61667,55.450001");
            this.put("\u58a8\u897f\u54e5", "19.428471,-99.127663");
            this.put("\u591a\u54e5", "7.46667,0.9");
            this.put("\u591a\u7c73\u5c3c\u514b", "15.23333,-61.316669");
            this.put("\u591a\u7c73\u5c3c\u52a0", "19.677299,-70.844276");
            this.put("\u5965\u5170\u7fa4\u5c9b", "60.26667,19.933331");
            this.put("\u5965\u5730\u5229", "48.208488,16.37208");
            this.put("\u59d4\u5185\u745e\u62c9", "10.48801,-66.879189");
            this.put("\u5b5f\u52a0\u62c9", "23.7104,90.40744");
            this.put("\u5b89\u54e5\u62c9", "-9.54015,16.34096");
            this.put("\u5b89\u572d\u62c9", "18.217039,-63.057831");
            this.put("\u5b89\u63d0\u74dc\u548c\u5df4\u5e03\u8fbe", "17.06671,-61.79303");
            this.put("\u5b89\u9053\u5c14", "42.50779,1.52109");
            this.put("\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a", "6.964,158.205994");
            this.put("\u5c3c\u52a0\u62c9\u74dc", "12.13282,-86.250397");
            this.put("\u5c3c\u65e5\u5229\u4e9a", "9.05735,7.48976");
            this.put("\u5c3c\u65e5\u5c14", "13.51366,2.1098");
            this.put("\u5c3c\u6cca\u5c14", "27.716667,85.316666");
            this.put("\u5df4\u52d2\u65af\u5766", "31.341579,34.345921");
            this.put("\u5df4\u54c8\u9a6c", "24.700001,-77.76667");
            this.put("\u5df4\u57fa\u65af\u5766", "33.721481,73.043289");
            this.put("\u5df4\u5df4\u591a\u65af", "13.1,-59.616669");
            this.put("\u5df4\u5e03\u4e9a\u65b0\u51e0\u5185\u4e9a", "-9.44314,147.179718");
            this.put("\u5df4\u62c9\u572d", "-26.033331,-55.933331");
            this.put("\u5df4\u62ff\u9a6c", "30.15946,-85.659828");
            this.put("\u5df4\u6797", "26.215361,50.583199");
            this.put("\u5df4\u897f", "-15.77972,-47.929722");
            this.put("\u5e03\u57fa\u7eb3\u6cd5\u7d22", "10.63333,-4.76667");
            this.put("\u5e03\u9686\u8fea", "-3.0804,29.391001");
            this.put("\u5e0c\u814a", "37.97945,23.716221");
            this.put("\u5e15\u52b3", "7.34257,134.478882");
            this.put("\u5e1d\u6c76\u5c9b", "-8.5,126.4");
            this.put("\u5e93\u514b\u7fa4\u5c9b", "-21.207781,-159.774994");
            this.put("\u5e93\u62c9\u7d22\u5c9b", "12.28333,-69.066673");
            this.put("\u5f00\u66fc\u7fa4\u5c9b", "19.283331,-81.25");
            this.put("\u5fb7\u56fd", "52.524368,13.41053");
            this.put("\u610f\u5927\u5229", "41.89193,12.51133");
            this.put("\u6240\u7f57\u95e8\u7fa4\u5c9b", "-8.76761,160.703354");
            this.put("\u6258\u514b\u52b3\u7fa4\u5c9b", "-8.5,-172.5");
            this.put("\u62c9\u8131\u7ef4\u4e9a", "56.950001,24.1");
            this.put("\u632a\u5a01", "59.912731,10.74609");
            this.put("\u6377\u514b", "49.30162,16.652531");
            this.put("\u6469\u5c14\u591a\u74e6", "47.005562,28.8575");
            this.put("\u6469\u6d1b\u54e5", "33.592781,-7.61916");
            this.put("\u6469\u7eb3\u54e5", "43.73333,7.41667");
            this.put("\u6587\u83b1", "4.94029,114.948059");
            this.put("\u6590\u6d4e", "-17.799999,177.416672");
            this.put("\u65af\u5a01\u58eb\u5170", "-26.549999,31.01667");
            this.put("\u65af\u6d1b\u4f10\u514b", "48.148159,17.106741");
            this.put("\u65af\u6d1b\u6587\u5c3c\u4e9a", "46.051079,14.50513");
            this.put("\u65af\u91cc\u5170\u5361", "6.93194,79.847778");
            this.put("\u65b0\u52a0\u5761", "1.28967,103.850067");
            this.put("\u65b0\u5580\u91cc\u591a\u5c3c\u4e9a", "-21.866671,166.050003");
            this.put("\u65b0\u897f\u5170", "-46.400002,168.350006");
            this.put("\u65e5\u672c", "35.689499,139.691711");
            this.put("\u667a\u5229", "-23.65,-70.400002");
            this.put("\u671d\u9c9c", "39.033852,125.754318");
            this.put("\u67ec\u57d4\u5be8", "11.56245,104.916008");
            this.put("\u683c\u6069\u897f\u5c9b", "49.459808,-2.53527");
            this.put("\u683c\u6797\u7eb3\u8fbe", "12.16462,-61.729649");
            this.put("\u683c\u9675\u5170\u5c9b", "66.939461,-53.6735");
            this.put("\u683c\u9c81\u5409\u4e9a", "41.694111,44.833679");
            this.put("\u68b5\u8482\u5188", "41.902359,12.45332");
            this.put("\u6bd4\u5229\u65f6", "50.850449,4.34878");
            this.put("\u6bdb\u5229\u5854\u5c3c\u4e9a", "18.08581,-15.9785");
            this.put("\u6bdb\u91cc\u6c42\u65af", "-20.16194,57.49889");
            this.put("\u6c64\u52a0", "-21.15,-175.216675");
            this.put("\u6c99\u7279\u963f\u62c9\u4f2f", "24.687731,46.721851");
            this.put("\u6cd5\u56fd", "48.853409,2.3488");
            this.put("\u6cd5\u5c5e\u5357\u90e8\u9886\u571f", "-49.349998,70.216667");
            this.put("\u6cd5\u5c5e\u5723\u9a6c\u4e01", "18.066669,-63.083328");
            this.put("\u6cd5\u5c5e\u572d\u4e9a\u90a3", "5.155,-54.347221");
            this.put("\u6cd5\u5c5e\u73bb\u5229\u5c3c\u897f\u4e9a", "-17.75,-149.283325");
            this.put("\u6cd5\u7f57\u7fa4\u5c9b", "62.009731,-6.77164");
            this.put("\u6ce2\u5170", "52.229771,21.01178");
            this.put("\u6ce2\u591a\u9ece\u5404", "18.158489,-66.801773");
            this.put("\u6ce2\u65af\u5c3c\u4e9a\u548c\u9ed1\u585e\u54e5\u7ef4\u90a3", "43.84864,18.35644");
            this.put("\u6cf0\u56fd", "13.75,100.51667");
            this.put("\u6cfd\u897f\u5c9b", "49.188042,-2.10491");
            this.put("\u6d25\u5df4\u5e03\u97e6", "-17.383329,30.4");
            this.put("\u6d2a\u90fd\u62c9\u65af", "14.0818,-87.20681");
            this.put("\u6d77\u5730", "18.539169,-72.334999");
            this.put("\u6fb3\u5927\u5229\u4e9a", "-35.283459,149.128067");
            this.put("\u7231\u5c14\u5170", "53.34399,-6.26719");
            this.put("\u7231\u6c99\u5c3c\u4e9a", "59.436958,24.753531");
            this.put("\u7259\u4e70\u52a0", "18.29434,-77.542389");
            this.put("\u7279\u514b\u65af\u548c\u51ef\u79d1\u65af\u7fa4\u5c9b", "21.46122,-71.141876");
            this.put("\u7279\u7acb\u5c3c\u8fbe\u548c\u591a\u5df4\u54e5", "10.63333,-61.283329");
            this.put("\u73bb\u5229\u7ef4\u4e9a", "-17.3895,-66.156799");
            this.put("\u7459\u9c81", "-0.55085,166.9252");
            this.put("\u745e\u5178", "59.332581,18.064899");
            this.put("\u745e\u58eb", "46.94809,7.44744");
            this.put("\u74dc\u5fb7\u7f57\u666e", "16.472059,-61.507778");
            this.put("\u74e6\u5229\u65af\u7fa4\u5c9b\u548c\u5bcc\u56fe\u7eb3\u7fa4\u5c9b", "-13.28163,-176.17453");
            this.put("\u74e6\u52aa\u963f\u56fe", "-15.53333,167.166672");
            this.put("\u7559\u5c3c\u6c6a\u5c9b", "-20.99667,55.67823");
            this.put("\u767d\u4fc4\u7f57\u65af", "53.900002,27.566668");
            this.put("\u767e\u6155\u5927\u7fa4\u5c9b", "32.291489,-64.777969");
            this.put("\u76ae\u7279\u51ef\u6069\u7fa4\u5c9b", "-25.065969,-130.101471");
            this.put("\u76f4\u5e03\u7f57\u9640", "36.144741,-5.35257");
            this.put("\u79d1\u5a01\u7279", "29.36972,47.978329");
            this.put("\u79d1\u6469\u7f57", "-12.13556,44.431671");
            this.put("\u79d1\u79d1\u65af\u7fa4\u5c9b", "-12.15681,96.82251");
            this.put("\u79d8\u9c81", "-5.2,-80.633331");
            this.put("\u7a81\u5c3c\u65af", "36.81897,10.16579");
            this.put("\u7acb\u9676\u5b9b", "54.689159,25.2798");
            this.put("\u7d22\u9a6c\u91cc", "2.1381,45.121201");
            this.put("\u7ea6\u65e6", "31.955219,35.94503");
            this.put("\u7eb3\u7c73\u6bd4\u4e9a", "-22.41667,14.96667");
            this.put("\u7ebd\u57c3\u5c9b", "-19.059521,-169.918671");
            this.put("\u7ef4\u5c14\u4eac\u7fa4\u5c9b", "18.41667,-64.616669");
            this.put("\u7f05\u7538", "19.745001,96.129723");
            this.put("\u7f57\u9a6c\u5c3c\u4e9a", "44.432251,26.10626");
            this.put("\u7f8e\u56fd", "38.895111,-77.036369");
            this.put("\u7f8e\u5c5e\u7ef4\u5c14\u4eac\u7fa4\u5c9b", "35.2,-80.899994");
            this.put("\u7f8e\u5c5e\u8428\u6469\u4e9a\u7fa4\u5c9b", "-14.27806,-170.702499");
            this.put("\u8001\u631d", "17.966669,102.599998");
            this.put("\u80af\u5c3c\u4e9a", "-0.17462,34.916302");
            this.put("\u82ac\u5170", "60.169521,24.93545");
            this.put("\u82cf\u4e39", "15.55177,32.53241");
            this.put("\u82cf\u91cc\u5357", "5.5,-54.049999");
            this.put("\u82f1\u56fd", "51.512791,-0.09184");
            this.put("\u8377\u5170", "52.37403,4.88969");
            this.put("\u8377\u5c5e\u5723\u9a6c\u4e01", "18.038679,-63.065418");
            this.put("\u83ab\u6851\u6bd4\u514b", "-25.965281,32.589169");
            this.put("\u83b1\u7d22\u6258", "-28.76659,28.249359");
            this.put("\u83f2\u5f8b\u5bbe", "14.6042,120.982201");
            this.put("\u8428\u5c14\u74e6\u591a", "13.59278,-89.827499");
            this.put("\u8428\u6469\u4e9a", "-13.83333,-171.766663");
            this.put("\u8461\u8404\u7259", "38.716671,-9.13333");
            this.put("\u8499\u53e4", "47.907711,106.88324");
            this.put("\u8499\u585e\u62c9\u7279", "16.79183,-62.210579");
            this.put("\u897f\u6492\u54c8\u62c9", "23.684771,-15.95798");
            this.put("\u897f\u73ed\u7259", "40.4165,-3.70256");
            this.put("\u8bfa\u798f\u514b\u5c9b", "-29.05459,167.966278");
            this.put("\u8c61\u7259\u6d77\u5cb8", "6.72972,-3.49639");
            this.put("\u8d1d\u5b81", "7.18286,1.99119");
            this.put("\u8d5e\u6bd4\u4e9a", "-15.40669,28.28713");
            this.put("\u8d64\u9053\u51e0\u5185\u4e9a", "1.29683,10.93691");
            this.put("\u8d8a\u5357", "21.0245,105.841171");
            this.put("\u963f\u585e\u62dc\u7586", "40.37767,49.89201");
            this.put("\u963f\u5bcc\u6c57", "34.52813,69.172333");
            this.put("\u963f\u5c14\u53ca\u5229\u4e9a", "36.752499,3.04197");
            this.put("\u963f\u5c14\u5df4\u5c3c\u4e9a", "40.598888,19.73472");
            this.put("\u963f\u62c9\u4f2f", "24.466669,54.366669");
            this.put("\u963f\u66fc", "23.613871,58.592201");
            this.put("\u963f\u6839\u5ef7", "-32.890839,-68.827171");
            this.put("\u963f\u9c81\u5df4", "12.51667,-69.949997");
            this.put("\u97e9\u56fd", "37.56826,126.977829");
            this.put("\u9a6c\u5176\u987f", "42,21.433331");
            this.put("\u9a6c\u5c14\u4ee3\u592b", "4.1748,73.508881");
            this.put("\u9a6c\u5c14\u7ef4\u7eb3\u65af\u7fa4\u5c9b", "-51.700001,-57.849998");
            this.put("\u9a6c\u6069\u5c9b", "54.150002,-4.48333");
            this.put("\u9a6c\u62c9\u7ef4", "-14.97928,34.95575");
            this.put("\u9a6c\u63d0\u5c3c\u514b", "14.86954,-61.11504");
            this.put("\u9a6c\u6765\u897f\u4e9a", "3.1412,101.686531");
            this.put("\u9a6c\u7ea6\u7279\u5c9b", "-12.7044,45.122311");
            this.put("\u9a6c\u7ecd\u5c14\u7fa4\u5c9b", "7.08971,171.380264");
            this.put("\u9a6c\u8033\u4ed6", "35.899719,14.51472");
            this.put("\u9a6c\u8fbe\u52a0\u65af\u52a0", "-18.913679,47.536129");
            this.put("\u9a6c\u91cc", "12.65,-8");
            this.put("\u9ece\u5df4\u5ae9", "33.888939,35.494419");
            this.put("\u9ed1\u5c71\u5171\u548c\u56fd", "42.441109,19.263611");
            this.put("\u4e2d\u975e", "7.361661,21.017058");
            this.put("\u4e9a\u6d32", "55.948734,98.70607");
            this.put("\u5317\u7f8e\u5730\u533a", "49.127607,-105.61989");
            this.put("\u5317\u9a6c\u5176\u987f", "41.10887,20.806359");
            this.put("\u5317\u9a6c\u91cc\u4e9a\u7eb3\u7fa4\u5c9b", "15.207633,145.760801");
            this.put("\u5357\u6781\u6d32", "-77.514571,67.232663");
            this.put("\u5370\u5c3c", "-0.882168,113.860961");
            this.put("\u5723\u5df4\u6cf0\u52d2\u7c73", "17.904541,-62.835857");
            this.put("\u5723\u76ae\u57c3\u5c14\u548c\u5bc6\u514b\u9686\u7fa4\u5c9b", "46.848725,-56.286004");
            this.put("\u5b5f\u52a0\u62c9\u56fd", "23.681552,90.368404");
            this.put("\u5bc6\u514b\u7f57\u5c3c\u897f\u4e9a\u8054\u90a6", "6.885566,158.227498");
            this.put("\u5e93\u62c9\u7d22", "12.211142,-69.033139");
            this.put("\u6258\u514b\u52b3", "-9.171349,-171.820804");
            this.put("\u62c9\u7f8e\u5730\u533a", "49.457634,-2.577804");
            this.put("\u6839\u897f\u5c9b", "49.457634,-2.577804");
            this.put("\u683c\u9675\u5170", "71.743234,-42.263953");
            this.put("\u6b27\u6d32", "52.204185,18.036424");
            this.put("\u6b27\u6d32\u5730\u533a", "52.204185,18.036424");
            this.put("\u6b27\u76df", "50.853795,4.35171");
            this.put("\u6b27\u7f8e\u5730\u533a", "52.449562,-32.397421");
            this.put("\u6bdb\u91cc\u5854\u5c3c\u4e9a", "20.91419,-10.560816");
            this.put("\u6cd5\u5c5e\u6ce2\u5229\u5c3c\u897f\u4e9a", "-17.726718,-149.414495");
            this.put("\u6fb3\u6d32", "-22.072304,134.647688");
            this.put("\u74e6\u5229\u65af\u548c\u5bcc\u56fe\u7eb3\u7fa4\u5c9b", "-14.235073,-177.942478");
            this.put("\u767e\u6155\u5927", "32.303161,-64.755674");
            this.put("\u798f\u514b\u5170\u7fa4\u5c9b", "-51.852787,-59.249987");
            this.put("\u79d1\u7279\u8fea\u74e6", "7.521915,-5.546505");
            this.put("\u79d1\u7d22\u6c83", "42.605397,21.100748");
            this.put("\u7ebd\u57c3", "-19.046517,-169.863209");
            this.put("\u7f8e\u5c5e\u8428\u6469\u4e9a", "-14.315434,-170.749447");
            this.put("\u7f8e\u6d32\u5730\u533a", "40.90915,-73.856778");
            this.put("\u8054\u5408\u56fd", "40.90915,-73.856778");
            this.put("\u82cf\u683c\u5170", "52.734451,-3.598159");
            this.put("\u82f1\u5c5e\u5370\u5ea6\u6d0b\u9886\u5730", "-6.659415,71.358178");
            this.put("\u82f1\u5c5e\u7ef4\u5c14\u4eac\u7fa4\u5c9b", "18.488459,-64.404253");
            this.put("\u8377\u5170\u52a0\u52d2\u6bd4", "51.893385,4.472645");
            this.put("\u8377\u5170\u7701", "52.116884,5.236074");
            this.put("\u8499\u7279\u585e\u62c9\u7279\u5c9b", "16.766314,-62.201411");
            this.put("\u963f\u8054\u914b", "24.73027,55.22819");
            this.put("\u975e\u6d32\u5730\u533a", "4.524836,24.252784");
            this.put("\u97e9\u56fd\u9996\u5c14", "37.546624,126.990617");
            this.put("\u9a6c\u7ea6\u7279", "-12.802392,45.140948");
            this.put("\u9ed1\u5c71", "42.746191,19.312874");
        }
    };
    public static final Map<String, String> PROVINCE_GEO = new HashMap<String, String>(){
        {
            this.put("\u4e2d\u56fd", "39.904000,116.391000");
            this.put("\u5317\u4eac", "39.904000,116.391000");
            this.put("\u4e0a\u6d77", "31.213000,121.445000");
            this.put("\u5929\u6d25", "39.117000,117.246000");
            this.put("\u91cd\u5e86", "29.581000,106.549000");
            this.put("\u4e91\u5357", "25.051000,102.702000");
            this.put("\u5409\u6797", "43.871000,125.324000");
            this.put("\u56db\u5ddd", "30.670000,104.071000");
            this.put("\u5b89\u5fbd", "31.861000,117.275000");
            this.put("\u5c71\u4e1c", "36.663000,117.009000");
            this.put("\u5c71\u897f", "37.893000,112.551000");
            this.put("\u5e7f\u4e1c", "23.108000,113.265000");
            this.put("\u6c5f\u82cf", "32.048000,118.769000");
            this.put("\u6c5f\u897f", "28.671000,115.889000");
            this.put("\u6cb3\u5317", "38.042000,114.498000");
            this.put("\u6cb3\u5357", "34.758000,113.641000");
            this.put("\u6d59\u6c5f", "30.319000,120.165000");
            this.put("\u6d77\u5357", "11.26,114.20");
            this.put("\u6e56\u5317", "30.573000,114.279000");
            this.put("\u6e56\u5357", "28.197000,112.967000");
            this.put("\u7518\u8083", "36.068000,103.751000");
            this.put("\u798f\u5efa", "26.071000,119.303000");
            this.put("\u8d35\u5dde", "26.572000,106.700000");
            this.put("\u8fbd\u5b81", "41.799000,123.418000");
            this.put("\u9655\u897f", "34.285000,108.969000");
            this.put("\u9752\u6d77", "36.621000,101.778000");
            this.put("\u9ed1\u9f99\u6c5f", "45.758000,126.645000");
            this.put("\u65b0\u7586", "43.781000,87.585000");
            this.put("\u5185\u8499\u53e4", "40.819000,111.686000");
            this.put("\u5b81\u590f", "38.468000,106.263000");
            this.put("\u897f\u85cf", "29.656000,91.126000");
            this.put("\u5e7f\u897f", "22.838000,108.295000");
            this.put("\u6fb3\u95e8", "22.20056,113.546112");
            this.put("\u9999\u6e2f", "22.285521,114.157692");
            this.put("\u53f0\u6e7e", "25.040000,121.516000");
        }
    };

    public static IPInfo getIpInfo(String ip) {
        CustomIPInfo customIPInfo;
        if (ip == null) {
            return UNKNOWN;
        }
        if (useCustomFlag && (customIPInfo = CUSTOM_IP_INFO_LIST.get(IpUtils.ip2BigInteger(ip))) != null) {
            return customIPInfo;
        }
        if (ip.contains(":")) {
            return IPv6InfoUtils.getIPv6Info(ip);
        }
        return IPv4InfoUtils.getIPv4Info(ip);
    }

    public static void useCustom(boolean useCustom) {
        useCustomFlag = useCustom;
    }

    public static void addCustom(CustomIPInfo customIPInfo) {
        CUSTOM_IP_INFO_LIST.put(customIPInfo.getIpInteger(), customIPInfo);
    }

    public static void removeCustom(String ip) {
        CUSTOM_IP_INFO_LIST.remove(IpUtils.ip2BigInteger(ip));
    }

    public static Collection<CustomIPInfo> listCustom() {
        return CUSTOM_IP_INFO_LIST.values();
    }

    public static void init() {
        IPv4InfoUtils.init();
        IPv6InfoUtils.init();
    }
}

