/*
 * Decompiled with CFR 0.152.
 */
package org.pegdown;

import java.util.List;
import org.parboiled.Context;
import org.parboiled.Rule;
import org.parboiled.support.StringBuilderVar;
import org.parboiled.support.Var;
import org.pegdown.Parser;
import org.pegdown.ast.AbstractNode;
import org.pegdown.ast.AnchorLinkSuperNode;
import org.pegdown.ast.DirectiveAttributes;
import org.pegdown.ast.DirectiveNode;
import org.pegdown.ast.Node;
import org.pegdown.ast.RootNode;
import org.pegdown.ast.SpecialTextNode;
import org.pegdown.ast.SuperNode;
import org.pegdown.plugins.PegDownPlugins;

public class ParserWithDirectives
extends Parser {
    public static char DIRECTIVE_MARKER = (char)64;
    public static char VAR_SUBSTITUTION_MARKER = (char)36;

    public ParserWithDirectives(Integer n, Long l, Parser.ParseRunnerProvider parseRunnerProvider, PegDownPlugins pegDownPlugins) {
        super(n, l, parseRunnerProvider, pegDownPlugins);
    }

    public Rule NonLinkInline() {
        Rule rule = super.NonLinkInline();
        return this.FirstOf(this.EscapedVarSubstitutionStart(), this.VarSubstitution(), new Object[]{this.InlineDirective(), rule});
    }

    public Rule Block() {
        Rule rule = super.Block();
        return this.Sequence(this.ZeroOrMore(this.BlankLine()), this.FirstOf(this.BlockDirective(), rule, new Object[0]), new Object[0]);
    }

    public Rule EscapedVarSubstitutionStart() {
        return this.Sequence(Character.valueOf('\\'), Character.valueOf(VAR_SUBSTITUTION_MARKER), new Object[]{this.push(new SpecialTextNode(this.match()))});
    }

    public Rule VarSubstitution() {
        return this.Sequence(Character.valueOf(VAR_SUBSTITUTION_MARKER), this.VarName(), new Object[]{Character.valueOf(VAR_SUBSTITUTION_MARKER), this.push((Object)new DirectiveNode(DirectiveNode.Format.Inline, "var", this.popAsString(), DirectiveNode.Source.Empty, new DirectiveAttributes.AttributeMap(), (Node)new SuperNode()))});
    }

    public Rule VarName() {
        StringBuilderVar stringBuilderVar = new StringBuilderVar();
        return this.Sequence(stringBuilderVar.clearContents(), this.Letter(), new Object[]{stringBuilderVar.append(this.matchedChar()), this.ZeroOrMore(this.FirstOf(this.Sequence(this.FirstOf(this.Alphanumeric(), this.AnyOf("+-_."), new Object[0]), stringBuilderVar.append(this.matchedChar()), new Object[0]), this.Sequence(Character.valueOf('\\'), Character.valueOf(VAR_SUBSTITUTION_MARKER), new Object[]{stringBuilderVar.append(VAR_SUBSTITUTION_MARKER)}), new Object[0])), this.push(stringBuilderVar.getString())});
    }

    public Rule InlineDirective() {
        return this.NodeSequence(new Object[]{Character.valueOf(DIRECTIVE_MARKER), this.DirectiveName(), this.DirectiveLabel(), this.DirectiveSource(), this.MaybeDirectiveAttributes(), this.push(this.inlineDirectiveNode())});
    }

    public Node inlineDirectiveNode() {
        DirectiveAttributes directiveAttributes = (DirectiveAttributes)this.pop();
        DirectiveNode.Source source = (DirectiveNode.Source)this.pop();
        Node node = this.popAsNode();
        String string = this.extractLabelText(node);
        String string2 = this.popAsString();
        return new DirectiveNode(DirectiveNode.Format.Inline, string2, string, source, directiveAttributes, node);
    }

    public String extractLabelText(Node node) {
        return this.getContext().getInputBuffer().extract(node.getStartIndex() + 1, node.getEndIndex() - 1);
    }

    public Rule BlockDirective() {
        return this.FirstOf(this.LeafBlockDirective(), this.ContainerBlockDirective(), new Object[0]);
    }

    public Rule LeafBlockDirective() {
        return this.NodeSequence(new Object[]{Character.valueOf(DIRECTIVE_MARKER), Character.valueOf(DIRECTIVE_MARKER), this.Sp(), this.DirectiveName(), this.MaybeDirectiveLabel(), this.DirectiveSource(), this.MaybeDirectiveAttributes(), this.Sp(), this.Newline(), this.push(this.leafBlockDirectiveNode())});
    }

    public Node leafBlockDirectiveNode() {
        DirectiveAttributes directiveAttributes = (DirectiveAttributes)this.pop();
        DirectiveNode.Source source = (DirectiveNode.Source)this.pop();
        Node node = this.popAsNode();
        String string = this.extractLabelText(node);
        String string2 = this.popAsString();
        return new DirectiveNode(DirectiveNode.Format.LeafBlock, string2, string, source, directiveAttributes, node);
    }

    public Rule ContainerBlockDirective() {
        Var var = new Var();
        return this.NodeSequence(new Object[]{this.ContainerBlockDirectiveStart((Var<Integer>)var), this.ContainerBlockDirectiveContents((Var<Integer>)var), this.ContainerBlockDirectiveEnd((Var<Integer>)var), this.push(this.containerBlockDirectiveNode())});
    }

    public Rule ContainerBlockDirectiveStart(Var<Integer> var) {
        return this.Sequence(var.clear(), this.ContainerBlockMarker(var), new Object[]{this.Sp(), this.DirectiveName(), this.MaybeDirectiveTextLabel(), this.DirectiveSource(), this.MaybeDirectiveAttributes(), this.Sp(), this.Newline()});
    }

    public Rule ContainerBlockMarker(Var<Integer> var) {
        return this.Sequence(this.NOrMore(DIRECTIVE_MARKER, 3), var.isSet() && this.matchLength() == ((Integer)var.get()).intValue() || var.isNotSet() && var.set((Object)this.matchLength()), new Object[0]);
    }

    public Rule ContainerBlockDirectiveContents(Var<Integer> var) {
        StringBuilderVar stringBuilderVar = new StringBuilderVar();
        return this.Sequence(this.push(this.getContext().getCurrentIndex()), stringBuilderVar.clearContents(), new Object[]{this.OneOrMore(this.TestNot(this.ContainerBlockDirectiveEnd(var)), ANY, new Object[]{stringBuilderVar.append(this.matchedChar())}), this.push(this.parseBlockContents(var, stringBuilderVar.appended("\n\n")))});
    }

    public Node parseBlockContents(Var<Integer> var, StringBuilderVar stringBuilderVar) {
        Context context = this.getContext();
        Integer n = (Integer)var.get();
        String string = stringBuilderVar.getString();
        RootNode rootNode = this.parseInternal(string.toCharArray());
        var.set((Object)n);
        this.setContext(context);
        Integer n2 = (Integer)this.pop();
        this.push(string);
        return this.shiftBlockIndices((Node)rootNode, n2);
    }

    public Node shiftBlockIndices(Node node, int n) {
        ((AbstractNode)node).shiftIndices(n);
        for (Node node2 : node.getChildren()) {
            this.shiftBlockIndices(node2, n);
        }
        return node;
    }

    public Rule ContainerBlockDirectiveEnd(Var<Integer> var) {
        return this.Sequence(this.Newline(), this.ContainerBlockMarker(var), new Object[]{this.Sp(), this.Newline()});
    }

    public Node containerBlockDirectiveNode() {
        Node node = this.popAsNode();
        String string = this.popAsString();
        DirectiveAttributes directiveAttributes = (DirectiveAttributes)this.pop();
        DirectiveNode.Source source = (DirectiveNode.Source)this.pop();
        String string2 = this.popAsString();
        String string3 = this.popAsString();
        return new DirectiveNode(DirectiveNode.Format.ContainerBlock, string3, string2, source, directiveAttributes, string, node);
    }

    public Rule DirectiveName() {
        return this.Sequence(this.DirectiveIdentifier(), this.push(this.match()), new Object[0]);
    }

    public Rule DirectiveIdentifier() {
        return this.Sequence(this.Letter(), this.ZeroOrMore(this.FirstOf(this.Alphanumeric(), this.AnyOf("-_.:"), new Object[0])), new Object[0]);
    }

    public Rule MaybeDirectiveLabel() {
        return this.NodeSequence(new Object[]{this.FirstOf(this.Sequence(this.Sp(), this.DirectiveLabel(), new Object[0]), this.push(new SuperNode()), new Object[0])});
    }

    public Rule DirectiveLabel() {
        return this.NodeSequence(new Object[]{this.Label()});
    }

    public Rule MaybeDirectiveTextLabel() {
        return this.FirstOf(this.Sequence(this.Sp(), this.DirectiveTextLabel(), new Object[0]), this.push(""), new Object[0]);
    }

    public Rule DirectiveTextLabel() {
        return this.Enclosed('[', ANY, ']');
    }

    public Rule DirectiveSource() {
        return this.FirstOf(this.DirectDirectiveSource(), this.RefDirectiveSource(), new Object[]{this.EmptyDirectiveSource()});
    }

    public Rule DirectDirectiveSource() {
        return this.Sequence(this.Sp(), this.Enclosed('(', ANY, ')'), new Object[]{this.push(new DirectiveNode.Source.Direct(this.popAsString()))});
    }

    public Rule RefDirectiveSource() {
        return this.Sequence(this.Sp(), this.TestNot("[]"), new Object[]{this.DirectiveTextLabel(), this.push(new DirectiveNode.Source.Ref(this.popAsString()))});
    }

    public Rule EmptyDirectiveSource() {
        return this.Sequence(this.Optional(this.Sequence(this.Sp(), "[]", new Object[0])), this.push(DirectiveNode.Source.Empty), new Object[0]);
    }

    public Rule Enclosed(char c, Rule rule, char c2) {
        return this.Sequence(Character.valueOf(c), this.Sequence(this.ZeroOrMore(this.TestNot(Character.valueOf(c2)), this.NotNewline(), new Object[]{rule}), this.push(this.match()), new Object[0]), new Object[]{Character.valueOf(c2)});
    }

    public Rule MaybeDirectiveAttributes() {
        return this.FirstOf(this.Sequence(this.Sp(), this.DirectiveAttributes(), new Object[0]), this.push(new DirectiveAttributes.AttributeMap()), new Object[0]);
    }

    public Rule DirectiveAttributes() {
        DirectiveAttributes.Var var = new DirectiveAttributes.Var();
        return this.Sequence(Character.valueOf('{'), this.Spn1(), new Object[]{this.ZeroOrMore(this.DirectiveAttribute(), this.Spn1(), new Object[]{var.add(this.popAsString(), this.popAsString())}), Character.valueOf('}'), this.push(var.getAttributes()), var.clear()});
    }

    public Rule DirectiveAttribute() {
        return this.FirstOf(this.DirectiveIdentifierAttribute(), this.DirectiveClassAttribute(), new Object[]{this.DirectiveKeyValueAttribute()});
    }

    public Rule DirectiveIdentifierAttribute() {
        return this.Sequence(this.push("identifier"), Character.valueOf('#'), new Object[]{this.DirectiveKey()});
    }

    public Rule DirectiveClassAttribute() {
        return this.Sequence(this.push("class"), Character.valueOf('.'), new Object[]{this.DirectiveKey()});
    }

    public Rule DirectiveKeyValueAttribute() {
        return this.Sequence(this.DirectiveKey(), Character.valueOf('='), new Object[]{this.DirectiveValue()});
    }

    public Rule DirectiveKey() {
        return this.Sequence(this.DirectiveIdentifier(), this.push(this.match()), new Object[0]);
    }

    public Rule DirectiveValue() {
        return this.FirstOf(this.DirectiveQuoted(), this.Sequence(this.OneOrMore(this.Nonspacechar()), this.push(this.match()), new Object[0]), new Object[0]);
    }

    public Rule DirectiveQuoted() {
        return this.FirstOf(this.Enclosed('\"', this.DirectiveLitChar(), '\"'), this.Enclosed('\'', this.DirectiveLitChar(), '\''), new Object[0]);
    }

    public Rule DirectiveLitChar() {
        return this.FirstOf(this.DirectiveEscapedChar(), ANY, new Object[0]);
    }

    public Rule DirectiveEscapedChar() {
        return this.Sequence(Character.valueOf('\\'), this.AnyOf("*_`&[]<>!#\\'\".+-(){}:|~"), new Object[0]);
    }

    public boolean wrapInAnchor() {
        SuperNode superNode;
        List list2;
        if (this.ext(1024) && !(list2 = (superNode = (SuperNode)this.peek()).getChildren()).isEmpty()) {
            int n = ((Node)list2.get(0)).getStartIndex();
            int n2 = ((Node)list2.get(list2.size() - 1)).getEndIndex();
            SuperNode superNode2 = new SuperNode(list2);
            superNode2.setStartIndex(n);
            superNode2.setEndIndex(n2);
            AnchorLinkSuperNode anchorLinkSuperNode = new AnchorLinkSuperNode((Node)superNode2);
            anchorLinkSuperNode.setStartIndex(n);
            anchorLinkSuperNode.setEndIndex(n2);
            list2.clear();
            list2.add(anchorLinkSuperNode);
        }
        return true;
    }
}

