/*
 * Decompiled with CFR 0.152.
 */
package org.pegdown.ast;

import java.util.List;
import org.parboiled.common.ImmutableList;
import org.pegdown.ast.AbstractNode;
import org.pegdown.ast.Node;
import org.pegdown.ast.TextNode;
import org.pegdown.ast.Visitor;

public class AnchorLinkSuperNode
extends AbstractNode {
    public final String name;
    public final Node contents;

    public AnchorLinkSuperNode(Node node) {
        this.name = this.createAnchor(node.getChildren());
        this.contents = node;
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.contents);
    }

    public void accept(Visitor visitor) {
        visitor.visit((Node)this);
    }

    private String createAnchor(List<Node> list2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node : list2) {
            if (!(node instanceof TextNode)) continue;
            TextNode textNode = (TextNode)node;
            for (char c : textNode.getText().toCharArray()) {
                if (Character.isLetterOrDigit(c)) {
                    stringBuilder.append(Character.toLowerCase(c));
                    continue;
                }
                if (stringBuilder.length() <= 0 || stringBuilder.charAt(stringBuilder.length() - 1) == '-') continue;
                stringBuilder.append('-');
            }
        }
        return stringBuilder.toString();
    }
}

