/*
 * Decompiled with CFR 0.152.
 */
package org.pegdown.ast;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.parboiled.common.StringUtils;

public interface DirectiveAttributes {
    public Set<String> keys();

    public String identifier();

    public List<String> classes();

    public String classesString();

    public String value(String var1);

    public String value(String var1, String var2);

    public List<String> values(String var1);

    public int intValue(String var1, int var2);

    public boolean booleanValue(String var1, boolean var2);

    public boolean isEmpty();

    public static class Var
    extends org.parboiled.support.Var<AttributeMap> {
        public boolean add(String string, String string2) {
            if (this.get() == null) {
                this.set(new AttributeMap());
            }
            ((AttributeMap)this.get()).add(string2, string);
            return true;
        }

        public DirectiveAttributes getAttributes() {
            return this.get() != null ? (AttributeMap)this.get() : new AttributeMap();
        }
    }

    public static class AttributeMap
    implements DirectiveAttributes {
        private final HashMap<String, List<String>> map = new HashMap();

        public String add(String string, String string2) {
            ArrayList<String> arrayList = this.map.containsKey(string) ? this.map.get(string) : new ArrayList<String>();
            arrayList.add(string2);
            this.map.put(string, arrayList);
            return string2;
        }

        @Override
        public Set<String> keys() {
            return this.map.keySet();
        }

        @Override
        public String identifier() {
            return this.value("identifier");
        }

        @Override
        public List<String> classes() {
            return this.values("class");
        }

        @Override
        public String classesString() {
            return StringUtils.join(this.classes(), (String)" ");
        }

        @Override
        public String value(String string) {
            List<String> list2 = this.values(string);
            return list2.isEmpty() ? null : list2.get(0);
        }

        @Override
        public String value(String string, String string2) {
            String string3 = this.value(string);
            return string3 == null ? string2 : string3;
        }

        @Override
        public List<String> values(String string) {
            return this.map.containsKey(string) ? this.map.get(string) : Collections.emptyList();
        }

        @Override
        public int intValue(String string, int n) {
            String string2 = this.value(string);
            try {
                return string2 == null ? n : Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                return n;
            }
        }

        @Override
        public boolean booleanValue(String string, boolean bl) {
            String string2 = this.value(string);
            if (string2 == null) {
                return bl;
            }
            if ("true".equals(string2) || "on".equals(string2) || "yes".equals(string2)) {
                return true;
            }
            if ("false".equals(string2) || "off".equals(string2) || "no".equals(string2)) {
                return false;
            }
            return bl;
        }

        @Override
        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("{");
            for (Map.Entry<String, List<String>> entry : this.map.entrySet()) {
                String string = entry.getKey();
                List<String> list2 = entry.getValue();
                stringBuilder.append(" " + string + "=" + list2);
            }
            stringBuilder.append(" }");
            return stringBuilder.toString();
        }
    }
}

