/*
 * Decompiled with CFR 0.152.
 */
package org.pegdown.ast;

import java.util.List;
import org.parboiled.common.ImmutableList;
import org.parboiled.common.StringUtils;
import org.pegdown.ast.AbstractNode;
import org.pegdown.ast.DirectiveAttributes;
import org.pegdown.ast.Node;
import org.pegdown.ast.Visitor;

public class DirectiveNode
extends AbstractNode {
    public final Format format;
    public final String name;
    public final String label;
    public final Source source;
    public final DirectiveAttributes attributes;
    public final String contents;
    public final Node contentsNode;

    public DirectiveNode(Format format, String string, String string2, Source source, DirectiveAttributes directiveAttributes, Node node) {
        this(format, string, string2, source, directiveAttributes, string2, node);
    }

    public DirectiveNode(Format format, String string, String string2, Source source, DirectiveAttributes directiveAttributes, String string3, Node node) {
        this.format = format;
        this.name = string;
        this.label = string2;
        this.source = source;
        this.attributes = directiveAttributes;
        this.contents = string3;
        this.contentsNode = node;
    }

    public List<Node> getChildren() {
        return ImmutableList.of((Object)this.contentsNode);
    }

    public void accept(Visitor visitor) {
        visitor.visit((Node)this);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        stringBuilder.append(" " + this.format.name() + " '" + this.name + "'");
        if (!this.label.isEmpty()) {
            stringBuilder.append(" [" + StringUtils.escape((String)this.label) + "]");
        }
        this.source.format(stringBuilder);
        if (!this.attributes.isEmpty()) {
            stringBuilder.append(" " + this.attributes.toString());
        }
        return stringBuilder.toString();
    }

    public static abstract class Source {
        public static final Source Empty = new Source(){

            @Override
            public void format(StringBuilder stringBuilder) {
            }
        };

        public abstract void format(StringBuilder var1);

        public static final class Ref
        extends Source {
            public final String value;

            public Ref(String string) {
                this.value = string;
            }

            @Override
            public void format(StringBuilder stringBuilder) {
                stringBuilder.append('[').append(this.value).append(']');
            }
        }

        public static final class Direct
        extends Source {
            public final String value;

            public Direct(String string) {
                this.value = string;
            }

            @Override
            public void format(StringBuilder stringBuilder) {
                stringBuilder.append('(').append(StringUtils.escape((String)this.value)).append(')');
            }
        }
    }

    public static enum Format {
        Inline,
        LeafBlock,
        ContainerBlock;

    }
}

