/*
 * Decompiled with CFR 0.152.
 */
package com.mangofactory.swagger.configuration;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import com.mangofactory.swagger.models.dto.jackson.SwaggerJacksonModule;
import com.mangofactory.swagger.models.property.provider.DefaultModelPropertiesProvider;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerAdapter;

public class JacksonSwaggerSupport
implements ApplicationContextAware {
    private ObjectMapper objectMapper;
    private RequestMappingHandlerAdapter requestMappingHandlerAdapter;
    private ApplicationContext applicationContext;

    @Autowired
    public void setRequestMappingHandlerAdapter(RequestMappingHandlerAdapter[] requestMappingHandlerAdapters) {
        if (requestMappingHandlerAdapters.length > 1) {
            for (RequestMappingHandlerAdapter adapter : requestMappingHandlerAdapters) {
                if (!adapter.getClass().getCanonicalName().equals(RequestMappingHandlerAdapter.class.getCanonicalName())) continue;
                this.requestMappingHandlerAdapter = adapter;
            }
        } else {
            this.requestMappingHandlerAdapter = requestMappingHandlerAdapters[0];
        }
    }

    @PostConstruct
    public void setup() {
        this.objectMapper = this.configureAllObjectMappers();
        Map beans = this.applicationContext.getBeansOfType(DefaultModelPropertiesProvider.class);
        for (DefaultModelPropertiesProvider defaultModelPropertiesProvider : beans.values()) {
            defaultModelPropertiesProvider.setObjectMapper(this.objectMapper);
        }
    }

    private ObjectMapper configureAllObjectMappers() {
        List messageConverters = this.requestMappingHandlerAdapter.getMessageConverters();
        ObjectMapper selected = null;
        Iterator<MappingJackson2HttpMessageConverter> i$ = this.jackson2Converters(messageConverters).iterator();
        while (i$.hasNext()) {
            MappingJackson2HttpMessageConverter messageConverter;
            MappingJackson2HttpMessageConverter m = messageConverter = i$.next();
            selected = m.getObjectMapper();
            SwaggerJacksonModule.maybeRegisterModule((ObjectMapper)selected);
        }
        ObjectMapper defaultMapper = new ObjectMapper();
        SwaggerJacksonModule.maybeRegisterModule((ObjectMapper)defaultMapper);
        return (ObjectMapper)Optional.fromNullable(selected).or((Object)defaultMapper);
    }

    private Iterable<MappingJackson2HttpMessageConverter> jackson2Converters(Iterable<HttpMessageConverter<?>> messageConverters) {
        return FluentIterable.from(messageConverters).filter(MappingJackson2HttpMessageConverter.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

