/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment;

import com.google.common.collect.Iterables;
import com.mayabot.nlp.common.FastCharReader;
import com.mayabot.nlp.common.ParagraphReader;
import com.mayabot.nlp.common.ParagraphReaderSmart;
import com.mayabot.nlp.common.ParagraphReaderString;
import com.mayabot.nlp.segment.Lexer;
import com.mayabot.nlp.segment.Sentence;
import com.mayabot.nlp.segment.WordTerm;
import com.mayabot.nlp.segment.reader.LexerIterator;
import java.io.Reader;
import java.util.Iterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;

public final class WordTermSequence
implements Iterable<WordTerm> {
    private final Iterator<WordTerm> source;

    public WordTermSequence(Iterator<WordTerm> source) {
        this.source = source;
    }

    public WordTermSequence(Iterable<WordTerm> source) {
        this(source.iterator());
    }

    public WordTermSequence(Lexer lexer, ParagraphReader paragraphReader) {
        this((Iterator<WordTerm>)((Object)new LexerIterator(lexer, paragraphReader)));
    }

    public WordTermSequence(Lexer lexer, Reader reader) {
        this((Iterator<WordTerm>)((Object)new LexerIterator(lexer, (ParagraphReader)new ParagraphReaderSmart(new FastCharReader(reader, 128), 1024))));
    }

    public WordTermSequence(Lexer lexer, String text) {
        this((Iterator<WordTerm>)((Object)new LexerIterator(lexer, (ParagraphReader)new ParagraphReaderString(text))));
    }

    @Override
    @NotNull
    public Iterator<WordTerm> iterator() {
        return this.source;
    }

    public Iterable<String> toWordSequence() {
        return Iterables.transform((Iterable)this, wordTerm -> wordTerm != null ? wordTerm.getWord() : null);
    }

    public Stream<WordTerm> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    public Sentence toSentence() {
        return Sentence.of(this);
    }
}

