/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.lexer.core;

import com.google.common.base.Preconditions;
import com.mayabot.nlp.injector.Singleton;
import com.mayabot.nlp.segment.lexer.core.BiGramTableDictionary;
import com.mayabot.nlp.segment.lexer.core.CoreDictionary;
import com.mayabot.nlp.segment.wordnet.BestPathAlgorithm;
import com.mayabot.nlp.segment.wordnet.Vertex;
import com.mayabot.nlp.segment.wordnet.VertexRow;
import com.mayabot.nlp.segment.wordnet.Wordnet;
import com.mayabot.nlp.segment.wordnet.Wordpath;

@Singleton
public final class ViterbiBestPathAlgorithm
implements BestPathAlgorithm {
    private BiGramTableDictionary coreBiGramTableDictionary;
    public final double dSmoothingPara = 0.1;
    public final double dTemp;
    private final double partA = 0.9;
    private final double partB;
    private final double PARTA_PARTB;
    private final double PARTTA_Dtemp;
    private final double PartZ;
    private final double value1;
    private final double value2;
    private final double value3;
    private final double value4;
    private final double value5;

    public ViterbiBestPathAlgorithm(BiGramTableDictionary coreBiGramTableDictionary, CoreDictionary coreDictionary) {
        this.coreBiGramTableDictionary = coreBiGramTableDictionary;
        this.dTemp = 1.0 / (double)coreDictionary.totalFreq() + 1.0E-5;
        this.partB = 1.0 - this.dTemp;
        this.PARTA_PARTB = 0.9 * this.partB;
        this.PARTTA_Dtemp = 0.9 * this.dTemp;
        this.PartZ = 0.1 / (double)coreDictionary.totalFreq();
        double[] values = new double[21];
        for (int i = 0; i < 21; ++i) {
            values[i] = Math.abs(-Math.log(this.PartZ * (double)i + this.PARTTA_Dtemp));
        }
        this.value1 = values[1];
        this.value2 = values[2];
        this.value3 = values[3];
        this.value4 = values[4];
        this.value5 = values[5];
    }

    @Override
    public Wordpath select(Wordnet wordnet) {
        int charSize = wordnet.getCharSizeLength();
        for (Vertex v = wordnet.getRow(0).first(); v != null; v = v.next()) {
            this.updateFrom(v, wordnet.getBeginRow().getFirst());
        }
        for (int i = 0; i < charSize; ++i) {
            VertexRow row = wordnet.row(i);
            if (row.isEmpty()) continue;
            for (Vertex node = row.first(); node != null; node = node.next()) {
                VertexRow toRow;
                if (node.from == null || (toRow = wordnet.row(i + node.length)).first() == null) continue;
                for (Vertex to = toRow.first(); to != null; to = to.next()) {
                    this.updateFrom(to, node);
                }
            }
        }
        return this.buildPath(wordnet);
    }

    private void updateFrom(Vertex the, Vertex from) {
        double weight = from.weight + this.calculateWeight(from, the);
        if (the.from == null || the.weight > weight) {
            the.from = from;
            the.weight = weight;
        }
    }

    private double calculateWeight(Vertex from, Vertex to) {
        int frequency = from.freq;
        if (frequency == 0) {
            frequency = 1;
        }
        int nTwoWordsFreq = this.coreBiGramTableDictionary.getBiFrequency(from.wordID, to.wordID);
        double value = 0.0;
        value = nTwoWordsFreq > 0 ? -Math.log(this.PartZ * (double)frequency + this.PARTA_PARTB * (double)nTwoWordsFreq / (double)frequency + this.PARTTA_Dtemp) : (frequency == 1 ? this.value1 : (frequency == 2 ? this.value1 : (frequency == 3 ? this.value3 : (frequency == 4 ? this.value4 : (frequency == 5 ? this.value5 : -Math.log(this.PartZ * (double)frequency + this.PARTTA_Dtemp))))));
        if (value < 0.0) {
            value = -value;
        }
        return value;
    }

    private Wordpath buildPath(Wordnet wordnet) {
        Wordpath wordPath = new Wordpath(wordnet);
        Vertex last = null;
        Vertex point = wordnet.getEndRow().first();
        while (point != null) {
            last = point;
            wordPath.combine(point);
            point = point.from;
        }
        Preconditions.checkState((last == wordnet.getBeginRow().first() ? 1 : 0) != 0, (Object)"\u975e\u5b8c\u6574\u8def\u5f84,\u6709\u53ef\u80fdwordnet\u521d\u59cb\u5316\u7684\u65f6\u5019\u5c31\u8def\u5f84\u4e0d\u5b8c\u6574");
        return wordPath;
    }
}

