/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.lexer.perceptron;

import com.google.common.base.Splitter;
import com.mayabot.nlp.perceptron.EvaluateUtilsKt;
import com.mayabot.nlp.segment.lexer.perceptron.CWSEvaluate;
import com.mayabot.nlp.segment.lexer.perceptron.CWSPerceptron;
import com.mayabot.nlp.utils.CharNormUtils;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/mayabot/nlp/segment/lexer/perceptron/CWSEvaluate;", "", "()V", "evaluate", "", "evaluateSample", "", "", "segmenter", "Lcom/mayabot/nlp/segment/lexer/perceptron/CWSPerceptron;", "mynlp-segment"})
public final class CWSEvaluate {
    public static final CWSEvaluate INSTANCE;

    @NotNull
    public final double[] evaluate(@NotNull List<String> evaluateSample2, @NotNull CWSPerceptron segmenter) {
        PrintStream printStream;
        CharSequence charSequence;
        Object object;
        Intrinsics.checkParameterIsNotNull(evaluateSample2, (String)"evaluateSample");
        Intrinsics.checkParameterIsNotNull((Object)segmenter, (String)"segmenter");
        int goldTotal = 0;
        int predTotal = 0;
        int correct = 0;
        Splitter splitter = Splitter.on((String)"\ufe4d").omitEmptyStrings();
        System.out.print("Evaluating 0%");
        long t1 = System.currentTimeMillis();
        int count = 0;
        for (String line : evaluateSample2) {
            String string;
            List wordArray = splitter.splitToList((CharSequence)CharNormUtils.convert((String)line));
            goldTotal += wordArray.size();
            List list = wordArray;
            Intrinsics.checkExpressionValueIsNotNull((Object)list, (String)"wordArray");
            String text = CollectionsKt.joinToString$default((Iterable)list, (CharSequence)"", null, null, (int)0, null, null, (int)62, null);
            List<String> predArray = segmenter.decodeToWordList(text);
            predTotal += predArray.size();
            correct += EvaluateUtilsKt.wordCorrect((List)wordArray, predArray);
            if (++count % 2000 != 0) continue;
            object = "%.2f";
            Object[] objectArray = new Object[]{(double)count * 100.0 / (double)evaluateSample2.size()};
            charSequence = new StringBuilder().append("\rEvaluating ");
            printStream = System.out;
            boolean bl = false;
            Intrinsics.checkExpressionValueIsNotNull((Object)String.format((String)object, Arrays.copyOf(objectArray, objectArray.length)), (String)"java.lang.String.format(this, *args)");
            printStream.print(((StringBuilder)charSequence).append(string).append('%').toString());
        }
        evaluate.1 $fun$prf$1 = evaluate.1.INSTANCE;
        double[] result = $fun$prf$1.invoke(goldTotal, predTotal, correct);
        System.out.print("\r");
        long t2 = System.currentTimeMillis();
        String string = "\u6b63\u786e\u7387(P) %.2f , \u53ec\u56de\u7387(R) %.2f , F1 %.2f";
        object = new Object[]{result[0], result[1], result[2]};
        printStream = System.out;
        boolean bl = false;
        String string2 = String.format(string, Arrays.copyOf(object, ((Object[])object).length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(this, *args)");
        charSequence = string2;
        printStream.println((String)charSequence);
        string = "Evaluate use time " + (t2 - t1) + " ms";
        boolean bl2 = false;
        System.out.println((Object)string);
        return result;
    }

    private CWSEvaluate() {
    }

    static {
        CWSEvaluate cWSEvaluate;
        INSTANCE = cWSEvaluate = new CWSEvaluate();
    }
}

