/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.lexer.perceptron;

import com.mayabot.nlp.segment.Nature;
import com.mayabot.nlp.segment.WordSplitAlgorithm;
import com.mayabot.nlp.segment.common.BaseSegmentComponent;
import com.mayabot.nlp.segment.lexer.core.CoreDictionaryImpl;
import com.mayabot.nlp.segment.lexer.perceptron.CWSPerceptron;
import com.mayabot.nlp.segment.lexer.perceptron.CwsService;
import com.mayabot.nlp.segment.wordnet.Vertex;
import com.mayabot.nlp.segment.wordnet.Wordnet;

public class PerceptronCwsSplitAlgorithm
extends BaseSegmentComponent
implements WordSplitAlgorithm {
    private final CWSPerceptron perceptron;
    private CwsService service;
    private CoreDictionaryImpl coreDictionary;

    public PerceptronCwsSplitAlgorithm(CwsService service, CoreDictionaryImpl coreDictionary) {
        super(-1000);
        this.service = service;
        this.coreDictionary = coreDictionary;
        this.perceptron = service.getPerceptron();
    }

    @Override
    public void fill(Wordnet wordnet) {
        char[] text = wordnet.getCharArray();
        int[] decode = this.perceptron.decode(text, false);
        int p = 0;
        for (int i = 0; i < decode.length; ++i) {
            int x = decode[i];
            if (x != 3 && x != 2) continue;
            this.combine(wordnet, text, p, i - p + 1);
            p = i + 1;
        }
        if (p < text.length) {
            this.combine(wordnet, text, p, text.length - p);
        }
    }

    private void combine(Wordnet wordnet, char[] text, int offset, int length) {
        Vertex vertex = wordnet.put(offset, length);
        int wordId = this.coreDictionary.wordId(text, offset, length);
        if (wordId >= 0) {
            int freq = this.coreDictionary.wordFreq(wordId);
            vertex.wordID = wordId;
            vertex.freq = freq;
        } else {
            vertex.setAbsWordNatureAndFreq(Nature.newWord);
        }
    }
}

