/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.collector;

import com.mayabot.nlp.segment.WordTerm;
import com.mayabot.nlp.segment.plugins.collector.WordTermCollector;
import com.mayabot.nlp.segment.wordnet.Vertex;
import com.mayabot.nlp.segment.wordnet.VertexRow;
import com.mayabot.nlp.segment.wordnet.Wordnet;
import com.mayabot.nlp.segment.wordnet.Wordpath;
import java.util.ArrayList;

public class IndexPickUpSubword
implements WordTermCollector.PickUpSubword {
    private int minWordLength = 2;

    @Override
    public void pickup(WordTerm term, Wordnet wordnet, Wordpath wordPath) {
        if (term.length() >= 3) {
            int from = term.offset;
            int to = from + term.length();
            int lastIndex = term.length() + term.offset;
            ArrayList<WordTerm> list = new ArrayList<WordTerm>();
            int lastMaxPoint = term.offset - 1;
            for (int i = term.offset; i < to; ++i) {
                VertexRow row = wordnet.getRow(i);
                for (Vertex small = row.first(); small != null; small = small.next()) {
                    if (small.length == term.length() || i + small.length() > lastIndex) continue;
                    WordTerm smallterm = new WordTerm(small.realWord(), small.nature, small.getRowNum());
                    if (small.length < this.minWordLength && (i <= lastMaxPoint || small.next() != null && small.next().length != term.length())) continue;
                    list.add(smallterm);
                    int lp = i + small.length - 1;
                    if (lp <= lastMaxPoint) continue;
                    lastMaxPoint = lp;
                }
            }
            if (!list.isEmpty()) {
                term.setSubword(list);
            }
        }
    }

    public int getMinWordLength() {
        return this.minWordLength;
    }

    public IndexPickUpSubword setMinWordLength(int minWordLength) {
        this.minWordLength = minWordLength;
        return this;
    }
}

