/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.customwords;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.mayabot.nlp.collection.dat.DoubleArrayTrieStringIntMap;
import com.mayabot.nlp.segment.plugins.customwords.CustomDictionary;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.TreeMap;

public class FileCustomDictionary
implements CustomDictionary {
    private DoubleArrayTrieStringIntMap trie;

    public FileCustomDictionary(File file, Charset charset) throws IOException {
        TreeMap dict = Maps.newTreeMap();
        ImmutableList lines = Files.asCharSource((File)file, (Charset)charset).readLines();
        for (String line : lines) {
            String[] params = line.split("\\s");
            dict.put(params[0], 1000);
        }
        this.trie = new DoubleArrayTrieStringIntMap(dict);
    }

    @Override
    public DoubleArrayTrieStringIntMap getTrie() {
        return this.trie;
    }
}

