/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.ner;

import com.google.common.collect.Lists;
import com.mayabot.nlp.common.FastStringBuilder;
import com.mayabot.nlp.hppc.IntArrayList;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.perceptron.Perceptron;
import com.mayabot.nlp.perceptron.PerceptronModel;
import com.mayabot.nlp.segment.WordTerm;
import com.mayabot.nlp.segment.plugins.ner.NERPerceptronFeature;
import com.mayabot.nlp.segment.wordnet.Vertex;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0005J\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00110\u0005J\u000e\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/mayabot/nlp/segment/plugins/ner/NERPerceptron;", "", "model", "Lcom/mayabot/nlp/perceptron/Perceptron;", "labels", "", "", "(Lcom/mayabot/nlp/perceptron/Perceptron;Ljava/util/List;)V", "featureSet", "Lcom/mayabot/nlp/perceptron/FeatureSet;", "getModel", "()Lcom/mayabot/nlp/perceptron/Perceptron;", "decode", "", "sentence", "Lcom/mayabot/nlp/segment/WordTerm;", "decodeVertexList", "Lcom/mayabot/nlp/segment/wordnet/Vertex;", "save", "dir", "Ljava/io/File;", "Companion", "mynlp-segment"})
public final class NERPerceptron {
    private final FeatureSet featureSet;
    @NotNull
    private final Perceptron model;
    private final List<String> labels;
    public static final Companion Companion = new Companion(null);

    /*
     * WARNING - void declaration
     */
    public final void decode(@NotNull List<WordTerm> sentence) {
        Intrinsics.checkParameterIsNotNull(sentence, (String)"sentence");
        FastStringBuilder buffer = new FastStringBuilder(100);
        ArrayList featureList = new ArrayList(sentence.size());
        int n = 0;
        int n2 = sentence.size();
        while (n < n2) {
            void i;
            Collection collection = featureList;
            IntArrayList intArrayList = NERPerceptronFeature.INSTANCE.extractFeatureVector(sentence, (int)i, this.featureSet, buffer);
            boolean bl = false;
            collection.add(intArrayList);
            ++i;
        }
        int[] result = this.model.decode((List)featureList);
        n2 = 0;
        int n3 = sentence.size();
        while (n2 < n3) {
            void i;
            sentence.get((int)i).setCustomFlag(this.labels.get(result[i]));
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> decodeVertexList(@NotNull List<? extends Vertex> sentence) {
        Object object;
        Intrinsics.checkParameterIsNotNull(sentence, (String)"sentence");
        FastStringBuilder buffer = new FastStringBuilder(100);
        ArrayList result = Lists.newArrayListWithExpectedSize((int)sentence.size());
        ArrayList featureList = new ArrayList(sentence.size());
        int n = 0;
        int n2 = sentence.size();
        while (n < n2) {
            void i;
            Collection collection = featureList;
            object = NERPerceptronFeature.INSTANCE.extractFeatureVector(sentence, (int)i, this.featureSet, buffer);
            boolean bl = false;
            collection.add(object);
            ++i;
        }
        int[] result2 = this.model.decode((List)featureList);
        n2 = 0;
        int n3 = sentence.size();
        while (n2 < n3) {
            void i;
            object = result;
            String string = this.labels.get(result2[i]);
            boolean bl = false;
            object.add(string);
            ++i;
        }
        ArrayList arrayList = result;
        Intrinsics.checkExpressionValueIsNotNull((Object)arrayList, (String)"result");
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull File dir) {
        Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
        dir.mkdirs();
        this.model.save(dir);
        Object object = new File(dir, "label.txt");
        Charset charset = Charsets.UTF_8;
        int n = 8192;
        boolean bl = false;
        Object object2 = object;
        boolean bl2 = false;
        Object object3 = object2;
        boolean bl3 = false;
        object3 = new FileOutputStream((File)object3);
        bl3 = false;
        object2 = new OutputStreamWriter((OutputStream)object3, charset);
        bl2 = false;
        BufferedWriter out = object2 instanceof BufferedWriter ? (BufferedWriter)object2 : new BufferedWriter((Writer)object2, n);
        object = out;
        boolean bl4 = false;
        Throwable throwable = null;
        try {
            BufferedWriter it = (BufferedWriter)object;
            boolean bl5 = false;
            Iterable $this$forEach$iv = this.labels;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String label = (String)element$iv;
                boolean bl6 = false;
                out.write(label + "\n");
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
    }

    @NotNull
    public final Perceptron getModel() {
        return this.model;
    }

    public NERPerceptron(@NotNull Perceptron model, @NotNull List<String> labels) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        Intrinsics.checkParameterIsNotNull(labels, (String)"labels");
        this.model = model;
        this.labels = labels;
        this.featureSet = this.model.featureSet();
    }

    @JvmStatic
    @NotNull
    public static final NERPerceptron load(@NotNull File dir) {
        return Companion.load(dir);
    }

    @JvmStatic
    @NotNull
    public static final NERPerceptron load(@NotNull InputStream parameterBin, @NotNull InputStream featureBin, @NotNull InputStream labelText) {
        return Companion.load(parameterBin, featureBin, labelText);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0007\u00a8\u0006\u000b"}, d2={"Lcom/mayabot/nlp/segment/plugins/ner/NERPerceptron$Companion;", "", "()V", "load", "Lcom/mayabot/nlp/segment/plugins/ner/NERPerceptron;", "dir", "Ljava/io/File;", "parameterBin", "Ljava/io/InputStream;", "featureBin", "labelText", "mynlp-segment"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final NERPerceptron load(@NotNull File dir) {
            Intrinsics.checkParameterIsNotNull((Object)dir, (String)"dir");
            Object object = new File(dir, "parameter.bin");
            int n = 0;
            object = new FileInputStream((File)object);
            n = 8192;
            int n2 = 0;
            BufferedInputStream parameterBin = object instanceof BufferedInputStream ? (BufferedInputStream)object : new BufferedInputStream((InputStream)object, n);
            Object object2 = new File(dir, "feature.dat");
            n2 = 0;
            object2 = new FileInputStream((File)object2);
            n2 = 8192;
            int n3 = 0;
            BufferedInputStream featureBin = object2 instanceof BufferedInputStream ? (BufferedInputStream)object2 : new BufferedInputStream((InputStream)object2, n2);
            Object object3 = new File(dir, "label.txt");
            n3 = 0;
            object3 = new FileInputStream((File)object3);
            n3 = 8192;
            boolean bl = false;
            BufferedInputStream labelText = object3 instanceof BufferedInputStream ? (BufferedInputStream)object3 : new BufferedInputStream((InputStream)object3, n3);
            return this.load(parameterBin, featureBin, labelText);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @JvmStatic
        @NotNull
        public final NERPerceptron load(@NotNull InputStream parameterBin, @NotNull InputStream featureBin, @NotNull InputStream labelText) {
            List list;
            Intrinsics.checkParameterIsNotNull((Object)parameterBin, (String)"parameterBin");
            Intrinsics.checkParameterIsNotNull((Object)featureBin, (String)"featureBin");
            Intrinsics.checkParameterIsNotNull((Object)labelText, (String)"labelText");
            Perceptron model = PerceptronModel.Companion.loadWithFeatureBin(parameterBin, featureBin);
            Closeable closeable = labelText;
            boolean bl = false;
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                InputStream inputStream = it;
                Charset charset = Charsets.UTF_8;
                boolean bl3 = false;
                Closeable closeable2 = inputStream;
                int n = 0;
                closeable2 = new InputStreamReader((InputStream)closeable2, charset);
                n = 8192;
                boolean bl4 = false;
                list = TextStreamsKt.readLines((Reader)(closeable2 instanceof BufferedReader ? (BufferedReader)closeable2 : new BufferedReader((Reader)closeable2, n)));
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            List labelList = list;
            return new NERPerceptron(model, labelList);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

