/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.plugins.ner;

import com.google.common.collect.Lists;
import com.mayabot.nlp.MynlpEnv;
import com.mayabot.nlp.Mynlps;
import com.mayabot.nlp.injector.Singleton;
import com.mayabot.nlp.logging.InternalLogger;
import com.mayabot.nlp.logging.InternalLoggerFactory;
import com.mayabot.nlp.perceptron.FeatureSet;
import com.mayabot.nlp.resources.NlpResource;
import com.mayabot.nlp.segment.Nature;
import com.mayabot.nlp.segment.Sentence;
import com.mayabot.nlp.segment.WordTerm;
import com.mayabot.nlp.segment.plugins.ner.NERPerceptron;
import com.mayabot.nlp.segment.plugins.pos.PerceptronPosService;
import com.mayabot.nlp.utils.CharNormUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

@Singleton
public class PerceptronNerService {
    private final PerceptronPosService posService;
    private NERPerceptron perceptron;
    static InternalLogger logger = InternalLoggerFactory.getInstance(PerceptronNerService.class);

    public PerceptronNerService(MynlpEnv mynlp, PerceptronPosService posService) throws Exception {
        this.posService = posService;
        NlpResource parameterResource = mynlp.loadResource("ner-model/parameter.bin");
        NlpResource labelResource = mynlp.loadResource("ner-model/label.txt");
        NlpResource featureResource = mynlp.loadResource("ner-model/feature.txt");
        File temp = mynlp.getCacheDir();
        File featureDatFile = new File(temp, featureResource.hash() + ".ner.dat");
        if (!featureDatFile.exists()) {
            FeatureSet featureSet = FeatureSet.readFromText((InputStream)new BufferedInputStream(featureResource.inputStream()));
            featureSet.save(featureDatFile, null);
        }
        this.perceptron = NERPerceptron.load(parameterResource.inputStream(), new BufferedInputStream(new FileInputStream(featureDatFile)), labelResource.inputStream());
    }

    public static List<WordTerm> toNerComposite(List<WordTerm> list) {
        boolean findLab = false;
        for (WordTerm x : list) {
            if (x.getCustomFlag() == null) continue;
            findLab = true;
            break;
        }
        if (!findLab) {
            return list;
        }
        ArrayList<WordTerm> result = new ArrayList<WordTerm>(list.size());
        ArrayList<WordTerm> temp = null;
        String nerPOS = null;
        for (WordTerm wordTerm : list) {
            String label = wordTerm.getCustomFlag();
            if ("O".equals(label) || "S".equals(label)) {
                if (temp != null) {
                    StringBuilder bigName = new StringBuilder();
                    for (WordTerm w : temp) {
                        bigName.append(w.word);
                    }
                    WordTerm group = new WordTerm(bigName.toString(), Nature.valueOf(nerPOS));
                    group.setOffset(((WordTerm)temp.get(0)).getOffset());
                    group.setSubword(temp);
                    temp = null;
                    nerPOS = null;
                    result.add(group);
                }
                result.add(wordTerm);
                continue;
            }
            if (temp == null) {
                temp = new ArrayList<WordTerm>();
                nerPOS = label.substring(2);
            }
            temp.add(wordTerm);
        }
        if (temp != null) {
            StringBuilder bigName = new StringBuilder();
            for (WordTerm w : temp) {
                bigName.append(w.word);
            }
            WordTerm wordTerm = new WordTerm(bigName.toString(), Nature.valueOf(nerPOS));
            wordTerm.setSubword(temp);
            result.add(wordTerm);
        }
        return result;
    }

    public List<WordTerm> ner(List<WordTerm> list, boolean pos) {
        if (pos) {
            this.posService.posFromTerm(list);
        }
        this.perceptron.decode(list);
        return PerceptronNerService.toNerComposite(list);
    }

    public Sentence ner(List<String> list) {
        ArrayList list2 = Lists.newArrayListWithCapacity((int)list.size());
        for (String w : list) {
            list2.add(new WordTerm(CharNormUtils.convert((String)w), Nature.x));
        }
        return Sentence.of(this.ner(list2, true));
    }

    public NERPerceptron getPerceptron() {
        return this.perceptron;
    }

    public static void main(String[] args) {
        PerceptronNerService service = (PerceptronNerService)Mynlps.instanceOf(PerceptronNerService.class);
        System.out.println(service.ner(Lists.newArrayList((Object[])"\u4e0a\u6d77 \u4e07\u884c \u4fe1\u606f \u79d1\u6280 \u6709\u9650 \u516c\u53f8 \u5728 \u4e0a\u6d77 \u6ce8\u518c \u6210\u529f".split(" "))));
        System.out.println(service.ner(Lists.newArrayList((Object[])"\u4e0a\u6d77 \u534e \u5b89 \u5de5\u4e1a \uff08 \u96c6\u56e2 \uff09 \u516c\u53f8 \u8463\u4e8b\u957f \u8c2d\u65ed\u5149 \u548c \u79d8\u4e66 \u80e1\u82b1\u854a \u6765 \u5230 \u7f8e\u56fd \u7ebd\u7ea6 \u73b0\u4ee3 \u827a\u672f \u535a\u7269\u9986 \u53c2\u89c2".split(" "))));
        System.out.println(service.ner(Lists.newArrayList((Object[])"\u8fd9|\u662f|\u4e0a\u6d77|\u4e07|\u884c|\u4fe1\u606f|\u79d1\u6280|\u6709\u9650\u516c\u53f8|\u7684|\u8d22\u52a1|\u62a5\u8868".split("\\|"))));
    }
}

