/*
 * Decompiled with CFR 0.152.
 */
package com.mayabot.nlp.segment.wordnet;

import com.mayabot.nlp.segment.Nature;
import com.mayabot.nlp.segment.WordAndNature;
import com.mayabot.nlp.segment.lexer.core.DictionaryAbsWords;
import com.mayabot.nlp.segment.wordnet.VertexRow;

public class Vertex
implements WordAndNature {
    public final int length;
    VertexRow vertexRow;
    Vertex next;
    Vertex prev;
    public int wordID = -1;
    public Nature nature;
    public int freq = 0;
    private String realWord;
    public Vertex from;
    public double weight;

    public Vertex(int length) {
        this.length = (short)length;
    }

    public Vertex(int length, int wordID, int freq) {
        this.length = (short)length;
        this.wordID = wordID;
        this.freq = freq;
    }

    public Vertex(Vertex node) {
        this.length = node.length;
        this.wordID = node.wordID;
    }

    @Override
    public String getWord() {
        return this.realWord();
    }

    @Override
    public String getNatureName() {
        if (this.nature != null) {
            return this.nature.name();
        }
        return "";
    }

    public Vertex copy() {
        return new Vertex(this);
    }

    public Vertex setAbsWordNatureAndFreq(Nature nature, int freq) {
        this.wordID = DictionaryAbsWords.nature2id(nature);
        if (this.wordID >= 0 && this.wordID <= 9) {
            this.nature = nature;
            this.freq = freq;
        }
        return this;
    }

    public Vertex setAbsWordNatureAndFreq(Nature nature) {
        return this.setAbsWordNatureAndFreq(nature, 10000);
    }

    public boolean isAbsWord() {
        return this.wordID >= 0 && this.wordID <= 9;
    }

    public String absWordLabel() {
        if (this.isAbsWord()) {
            return DictionaryAbsWords.id2label(this.wordID);
        }
        return null;
    }

    public boolean isNature(Nature nature) {
        return this.nature != null && nature == this.nature;
    }

    public VertexRow follow() {
        if (this.length == 0) {
            return null;
        }
        VertexRow follow = this.vertexRow.wordnet.getRow(this.vertexRow.rowNum + this.length);
        if (follow == null) {
            return null;
        }
        if (follow.isEmpty()) {
            return null;
        }
        return follow;
    }

    public String realWord() {
        if (this.realWord == null) {
            this.realWord = this.vertexRow.subString(this.length);
        }
        return this.realWord;
    }

    public int offset() {
        return this.vertexRow.rowNum;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.length;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vertex other = (Vertex)obj;
        return this.length == other.length;
    }

    public String toString() {
        return "Vertex [length=" + this.length + "]";
    }

    public Vertex next() {
        return this.next;
    }

    public int length() {
        return this.length;
    }

    public VertexRow getVertexRow() {
        return this.vertexRow;
    }

    public int getRowNum() {
        return this.vertexRow.rowNum;
    }

    public Vertex getNext() {
        return this.next;
    }
}

