/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.eventhubs.impl;

import com.microsoft.azure.eventhubs.OperationCancelledException;
import com.microsoft.azure.eventhubs.TimeoutException;
import com.microsoft.azure.eventhubs.impl.AmqpConnection;
import com.microsoft.azure.eventhubs.impl.DispatchHandler;
import com.microsoft.azure.eventhubs.impl.FaultTolerantObject;
import com.microsoft.azure.eventhubs.impl.IOObject;
import com.microsoft.azure.eventhubs.impl.MessageOperationResult;
import com.microsoft.azure.eventhubs.impl.OperationResult;
import com.microsoft.azure.eventhubs.impl.OperationResultBase;
import com.microsoft.azure.eventhubs.impl.ReactorDispatcher;
import com.microsoft.azure.eventhubs.impl.RequestResponseChannel;
import com.microsoft.azure.eventhubs.impl.RequestResponseCloser;
import com.microsoft.azure.eventhubs.impl.RequestResponseOpener;
import com.microsoft.azure.eventhubs.impl.SessionProvider;
import com.microsoft.azure.eventhubs.impl.StringUtil;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.amqp.messaging.AmqpValue;
import org.apache.qpid.proton.amqp.messaging.ApplicationProperties;
import org.apache.qpid.proton.message.Message;

final class ManagementChannel {
    final FaultTolerantObject<RequestResponseChannel> innerChannel;

    ManagementChannel(SessionProvider sessionProvider, AmqpConnection connection, String clientId, ScheduledExecutorService executor) {
        RequestResponseCloser closer = new RequestResponseCloser();
        this.innerChannel = new FaultTolerantObject<RequestResponseChannel>(new RequestResponseOpener(sessionProvider, clientId, "mgmt-session", "mgmt", "$management", connection, executor), closer);
        closer.setInnerChannel(this.innerChannel);
    }

    public CompletableFuture<Map<String, Object>> request(ReactorDispatcher dispatcher, Map<String, Object> request, final long timeoutInMillis) {
        Message requestMessage = Proton.message();
        ApplicationProperties applicationProperties = new ApplicationProperties(request);
        requestMessage.setApplicationProperties(applicationProperties);
        final CompletableFuture<Map<String, Object>> resultFuture = new CompletableFuture<Map<String, Object>>();
        try {
            dispatcher.invoke((int)timeoutInMillis, new DispatchHandler(){

                @Override
                public void onEvent() {
                    String errorMessage;
                    RequestResponseChannel channel = ManagementChannel.this.innerChannel.unsafeGetIfOpened();
                    if (channel != null && channel.getState() == IOObject.IOObjectState.OPENED) {
                        String remoteContainerId = channel.getSendLink().getSession().getConnection().getRemoteContainer();
                        errorMessage = String.format(Locale.US, "Management request timed out (%sms), after not receiving response from service. TrackingId: %s", timeoutInMillis, StringUtil.isNullOrEmpty(remoteContainerId) ? "n/a" : remoteContainerId);
                    } else {
                        errorMessage = "Management request timed out on the client - enable info level tracing to diagnose.";
                    }
                    resultFuture.completeExceptionally(new TimeoutException(errorMessage));
                }
            });
        }
        catch (IOException ioException) {
            resultFuture.completeExceptionally(new OperationCancelledException("Sending request failed while dispatching to Reactor, see cause for more details.", (Throwable)ioException));
            return resultFuture;
        }
        if (timeoutInMillis > 5L) {
            MessageOperationResult messageOperation = new MessageOperationResult(response -> {
                if (response.getBody() != null) {
                    resultFuture.complete((Map)((AmqpValue)response.getBody()).getValue());
                }
            }, resultFuture::completeExceptionally);
            OperationResultBase operation = new OperationResultBase(result -> result.request(requestMessage, messageOperation), resultFuture::completeExceptionally);
            this.innerChannel.runOnOpenedObject(dispatcher, operation);
        }
        return resultFuture;
    }

    public void close(ReactorDispatcher reactorDispatcher, OperationResult<Void, Exception> closeCallback) {
        this.innerChannel.close(reactorDispatcher, closeCallback);
    }
}

