/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.Attendee;
import microsoft.exchange.webservices.data.ComplexPropertyCollection;
import microsoft.exchange.webservices.data.EditorBrowsable;
import microsoft.exchange.webservices.data.EditorBrowsableState;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.Strings;

@EditorBrowsable(state=EditorBrowsableState.Never)
public final class AttendeeCollection
extends ComplexPropertyCollection<Attendee> {
    protected AttendeeCollection() {
    }

    public void add(Attendee attendee) {
        this.internalAdd(attendee);
    }

    public Attendee add(String smtpAddress) throws Exception {
        Attendee result = new Attendee(smtpAddress);
        this.internalAdd(result);
        return result;
    }

    public Attendee add(String name, String smtpAddress) {
        Attendee result = new Attendee(name, smtpAddress);
        this.internalAdd(result);
        return result;
    }

    public void clear() {
        this.internalClear();
    }

    public void removeAt(int index) {
        if (index < 0 || index >= this.getCount()) {
            throw new IllegalArgumentException("parameter 'index' : " + Strings.IndexIsOutOfRange);
        }
        this.internalRemoveAt(index);
    }

    public boolean remove(Attendee attendee) throws Exception {
        EwsUtilities.validateParam(attendee, "attendee");
        return this.internalRemove(attendee);
    }

    @Override
    protected Attendee createComplexProperty(String xmlElementName) {
        if (xmlElementName.equalsIgnoreCase("Attendee")) {
            return new Attendee();
        }
        return null;
    }

    @Override
    protected String getCollectionItemXmlElementName(Attendee attendee) {
        return "Attendee";
    }
}

