/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import microsoft.exchange.webservices.data.AutodiscoverResponse;
import microsoft.exchange.webservices.data.EwsXmlReader;
import microsoft.exchange.webservices.data.XmlNamespace;

public abstract class AutodiscoverResponseCollection<TResponse extends AutodiscoverResponse>
extends AutodiscoverResponse
implements Iterable<TResponse> {
    private List<TResponse> responses = new ArrayList<TResponse>();

    protected AutodiscoverResponseCollection() {
    }

    public int getCount() {
        return this.responses.size();
    }

    public TResponse getTResponseAtIndex(int index) {
        return (TResponse)((AutodiscoverResponse)this.responses.get(index));
    }

    protected List<TResponse> getResponses() {
        return this.responses;
    }

    @Override
    protected void loadFromXml(EwsXmlReader reader, String endElementName) throws Exception {
        do {
            reader.read();
            if (reader.getNodeType().getNodeType() != 1) continue;
            if (reader.getLocalName().equals(this.getResponseCollectionXmlElementName())) {
                this.loadResponseCollectionFromXml(reader);
                continue;
            }
            super.loadFromXml(reader, endElementName);
        } while (!reader.isEndElement(XmlNamespace.Autodiscover, endElementName));
    }

    private void loadResponseCollectionFromXml(EwsXmlReader reader) throws Exception {
        if (!reader.isEmptyElement()) {
            do {
                reader.read();
                if (reader.getNodeType().getNodeType() != 1 || !reader.getLocalName().equals(this.getResponseInstanceXmlElementName())) continue;
                TResponse response = this.createResponseInstance();
                ((AutodiscoverResponse)response).loadFromXml(reader, this.getResponseInstanceXmlElementName());
                this.responses.add(response);
            } while (!reader.isEndElement(XmlNamespace.Autodiscover, this.getResponseCollectionXmlElementName()));
        } else {
            reader.read();
        }
    }

    protected abstract String getResponseCollectionXmlElementName();

    protected abstract String getResponseInstanceXmlElementName();

    protected abstract TResponse createResponseInstance();

    @Override
    public Iterator<TResponse> iterator() {
        return this.responses.iterator();
    }
}

