/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.CalendarActionResults;
import microsoft.exchange.webservices.data.EditorBrowsable;
import microsoft.exchange.webservices.data.EditorBrowsableState;
import microsoft.exchange.webservices.data.EmailMessage;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.MessageDisposition;
import microsoft.exchange.webservices.data.ResponseObject;
import microsoft.exchange.webservices.data.WellKnownFolderName;

@EditorBrowsable(state=EditorBrowsableState.Never)
public abstract class CalendarResponseMessageBase<TMessage extends EmailMessage>
extends ResponseObject<TMessage> {
    CalendarResponseMessageBase(Item referenceItem) throws Exception {
        super(referenceItem);
    }

    public CalendarActionResults calendarSave(FolderId destinationFolderId) throws Exception {
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        return new CalendarActionResults(this.internalCreate(destinationFolderId, MessageDisposition.SaveOnly));
    }

    public CalendarActionResults calendarSave(WellKnownFolderName destinationFolderName) throws Exception {
        return new CalendarActionResults(this.internalCreate(new FolderId(destinationFolderName), MessageDisposition.SaveOnly));
    }

    public CalendarActionResults calendarSave() throws Exception {
        return new CalendarActionResults(this.internalCreate(null, MessageDisposition.SaveOnly));
    }

    public CalendarActionResults calendarSend() throws Exception {
        return new CalendarActionResults(this.internalCreate(null, MessageDisposition.SendOnly));
    }

    public CalendarActionResults calendarSendAndSaveCopy(FolderId destinationFolderId) throws Exception {
        EwsUtilities.validateParam(destinationFolderId, "destinationFolderId");
        return new CalendarActionResults(this.internalCreate(destinationFolderId, MessageDisposition.SendAndSaveCopy));
    }

    public CalendarActionResults calendarSendAndSaveCopy(WellKnownFolderName destinationFolderName) throws Exception {
        return new CalendarActionResults(this.internalCreate(new FolderId(destinationFolderName), MessageDisposition.SendAndSaveCopy));
    }

    public CalendarActionResults calendarSendAndSaveCopy() throws Exception {
        return new CalendarActionResults(this.internalCreate(null, MessageDisposition.SendAndSaveCopy));
    }
}

