/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.EnumSet;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.OutParam;
import microsoft.exchange.webservices.data.PropertyBag;
import microsoft.exchange.webservices.data.PropertyDefinition;
import microsoft.exchange.webservices.data.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.ServiceObject;
import microsoft.exchange.webservices.data.XmlNamespace;

abstract class ComplexPropertyDefinitionBase
extends PropertyDefinition {
    protected ComplexPropertyDefinitionBase(String xmlElementName, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version) {
        super(xmlElementName, flags, version);
    }

    protected ComplexPropertyDefinitionBase(String xmlElementName, String uri, ExchangeVersion version) {
        super(xmlElementName, uri, version);
    }

    protected ComplexPropertyDefinitionBase(String xmlElementName, String uri, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version) {
        super(xmlElementName, uri, flags, version);
    }

    protected abstract ComplexProperty createPropertyInstance(ServiceObject var1);

    protected void internalLoadFromXml(EwsServiceXmlReader reader, PropertyBag propertyBag) throws Exception {
        OutParam<Object> complexProperty = new OutParam<Object>();
        if (!propertyBag.tryGetValue(this, complexProperty) || !this.hasFlag(PropertyDefinitionFlags.ReuseInstance)) {
            complexProperty.setParam((Object)this.createPropertyInstance(propertyBag.getOwner()));
        }
        if (complexProperty.getParam() instanceof ComplexProperty) {
            ComplexProperty c = (ComplexProperty)complexProperty.getParam();
            c.loadFromXml(reader, reader.getLocalName());
        }
        propertyBag.setObjectFromPropertyDefinition(this, complexProperty.getParam());
    }

    @Override
    protected void loadPropertyValueFromXml(EwsServiceXmlReader reader, PropertyBag propertyBag) throws Exception {
        reader.ensureCurrentNodeIsStartElement(XmlNamespace.Types, this.getXmlElement());
        if (!reader.isEmptyElement() || reader.hasAttributes()) {
            this.internalLoadFromXml(reader, propertyBag);
        }
        reader.readEndElementIfNecessary(XmlNamespace.Types, this.getXmlElement());
    }

    @Override
    protected void writePropertyValueToXml(EwsServiceXmlWriter writer, PropertyBag propertyBag, boolean isUpdateOperation) throws Exception {
        ComplexProperty complexProperty = (ComplexProperty)propertyBag.getObjectFromPropertyDefinition(this);
        if (complexProperty != null) {
            complexProperty.writeToXml(writer, this.getXmlElement());
        }
    }
}

