/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.net.URI;
import java.util.List;
import microsoft.exchange.webservices.data.AutodiscoverError;
import microsoft.exchange.webservices.data.AutodiscoverResponseType;
import microsoft.exchange.webservices.data.EditorBrowsable;
import microsoft.exchange.webservices.data.EditorBrowsableState;
import microsoft.exchange.webservices.data.EwsXmlReader;
import microsoft.exchange.webservices.data.GetUserSettingsResponse;
import microsoft.exchange.webservices.data.UserSettingName;
import microsoft.exchange.webservices.data.XmlNamespace;

@EditorBrowsable(state=EditorBrowsableState.Never)
abstract class ConfigurationSettingsBase {
    private AutodiscoverError error;

    protected ConfigurationSettingsBase() {
    }

    protected boolean tryReadCurrentXmlElement(EwsXmlReader reader) throws Exception {
        if (reader.getLocalName().equalsIgnoreCase("Error")) {
            this.error = AutodiscoverError.parse(reader);
            return true;
        }
        return false;
    }

    protected void loadFromXml(EwsXmlReader reader) throws Exception {
        reader.readStartElement(XmlNamespace.NotSpecified, "Autodiscover");
        reader.readStartElement(XmlNamespace.NotSpecified, "Response");
        do {
            reader.read();
            if (!reader.isStartElement() || this.tryReadCurrentXmlElement(reader)) continue;
            reader.skipCurrentElement();
        } while (!reader.isEndElement(XmlNamespace.NotSpecified, "Response"));
        reader.readEndElement(XmlNamespace.NotSpecified, "Autodiscover");
    }

    protected abstract String getNamespace();

    protected abstract void makeRedirectionResponse(URI var1);

    protected abstract AutodiscoverResponseType getResponseType();

    protected abstract String getRedirectTarget();

    protected abstract GetUserSettingsResponse convertSettings(String var1, List<UserSettingName> var2);

    protected AutodiscoverError getError() {
        return this.error;
    }
}

