/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.ArgumentOutOfRangeException;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.DayOfTheWeek;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class DayOfTheWeekCollection
extends ComplexProperty
implements Iterable<DayOfTheWeek> {
    private List<DayOfTheWeek> items = new ArrayList<DayOfTheWeek>();

    protected DayOfTheWeekCollection() {
    }

    private String toString(String separator) {
        if (this.getCount() == 0) {
            return "";
        }
        StringBuffer daysOfTheWeekstr = new StringBuffer();
        for (int i = 0; i < this.getCount(); ++i) {
            if (daysOfTheWeekstr.length() == 0) {
                daysOfTheWeekstr.append(this.items.get(i).toString());
                continue;
            }
            daysOfTheWeekstr.append(separator);
            daysOfTheWeekstr.append(this.items.get(i).toString());
        }
        return daysOfTheWeekstr.toString();
    }

    @Override
    protected void loadFromXml(EwsServiceXmlReader reader, String xmlElementName) throws Exception {
        reader.ensureCurrentNodeIsStartElement(XmlNamespace.Types, xmlElementName);
        EwsUtilities.parseEnumValueList(DayOfTheWeek.class, this.items, reader.readElementValue(), ' ');
    }

    @Override
    protected void writeToXml(EwsServiceXmlWriter writer, String xmlElementName) throws XMLStreamException, ServiceXmlSerializationException {
        String daysOfWeekAsString = this.toString(" ");
        if (daysOfWeekAsString != null && !daysOfWeekAsString.isEmpty()) {
            writer.writeElementValue(XmlNamespace.Types, "DaysOfWeek", daysOfWeekAsString);
        }
    }

    public String toString() {
        return this.toString(",");
    }

    public void add(DayOfTheWeek dayOfTheWeek) {
        if (!this.items.contains((Object)dayOfTheWeek)) {
            this.items.add(dayOfTheWeek);
            this.changed();
        }
    }

    public void addRange(Iterator<DayOfTheWeek> daysOfTheWeek) {
        while (daysOfTheWeek.hasNext()) {
            this.add(daysOfTheWeek.next());
        }
    }

    public void clear() {
        if (this.getCount() > 0) {
            this.items.clear();
            this.changed();
        }
    }

    public boolean remove(DayOfTheWeek dayOfTheWeek) {
        boolean result = this.items.remove((Object)dayOfTheWeek);
        if (result) {
            this.changed();
        }
        return result;
    }

    public void removeAt(int index) throws ArgumentOutOfRangeException {
        if (index < 0 || index >= this.getCount()) {
            throw new ArgumentOutOfRangeException("index", Strings.IndexIsOutOfRange);
        }
        this.items.remove(index);
        this.changed();
    }

    public DayOfTheWeek getWeekCollectionAtIndex(int index) {
        return this.items.get(index);
    }

    public int getCount() {
        return this.items.size();
    }

    @Override
    public Iterator<DayOfTheWeek> iterator() {
        return this.items.iterator();
    }
}

