/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.DelegatePermissions;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.StandardUser;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.UserId;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class DelegateUser
extends ComplexProperty {
    private UserId userId = new UserId();
    private DelegatePermissions permissions = new DelegatePermissions();
    private boolean receiveCopiesOfMeetingMessages = false;
    private boolean viewPrivateItems = false;

    public DelegateUser() {
    }

    public DelegateUser(String primarySmtpAddress) {
        this();
        this.userId.setPrimarySmtpAddress(primarySmtpAddress);
    }

    public DelegateUser(StandardUser standardUser) {
        this();
        this.userId.setStandardUser(standardUser);
    }

    public UserId getUserId() {
        return this.userId;
    }

    public DelegatePermissions getPermissions() {
        return this.permissions;
    }

    public boolean getReceiveCopiesOfMeetingMessages() {
        return this.receiveCopiesOfMeetingMessages;
    }

    public void setReceiveCopiesOfMeetingMessages(boolean value) {
        this.receiveCopiesOfMeetingMessages = value;
    }

    public boolean getViewPrivateItems() {
        return this.viewPrivateItems;
    }

    public void setViewPrivateItems(boolean value) {
        this.viewPrivateItems = value;
    }

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("UserId")) {
            this.userId = new UserId();
            this.userId.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equals("UserId")) {
            this.permissions.reset();
            this.permissions.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equals("ReceiveCopiesOfMeetingMessages")) {
            this.receiveCopiesOfMeetingMessages = reader.readElementValue(Boolean.class);
            return true;
        }
        if (reader.getLocalName().equals("ViewPrivateItems")) {
            this.viewPrivateItems = reader.readElementValue(Boolean.class);
            return true;
        }
        return false;
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.getUserId().writeToXml(writer, "UserId");
        this.getPermissions().writeToXml(writer, "DelegatePermissions");
        writer.writeElementValue(XmlNamespace.Types, "ReceiveCopiesOfMeetingMessages", this.receiveCopiesOfMeetingMessages);
        writer.writeElementValue(XmlNamespace.Types, "ViewPrivateItems", this.viewPrivateItems);
    }

    @Override
    protected void internalValidate() throws ServiceValidationException {
        if (this.getUserId() == null) {
            throw new ServiceValidationException(Strings.UserIdForDelegateUserNotSpecified);
        }
        if (!this.getUserId().isValid()) {
            throw new ServiceValidationException(Strings.DelegateUserHasInvalidUserId);
        }
    }

    protected void validateAddDelegate() throws ServiceValidationException, Exception {
        this.permissions.validateAddDelegate();
    }

    protected void validateUpdateDelegate() throws Exception {
        this.permissions.validateUpdateDelegate();
    }
}

