/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.List;
import microsoft.exchange.webservices.data.Attachment;
import microsoft.exchange.webservices.data.DeleteAttachmentResponse;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.XmlNamespace;

final class DeleteAttachmentRequest
extends MultiResponseServiceRequest<DeleteAttachmentResponse> {
    private List<Attachment> attachments = new ArrayList<Attachment>();

    protected DeleteAttachmentRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() {
        try {
            super.validate();
            EwsUtilities.validateParamCollection(this.getAttachments().iterator(), "Attachments");
            for (int i = 0; i < this.attachments.size(); ++i) {
                EwsUtilities.validateParam(this.attachments.get(i).getId(), String.format("Attachment[%d].Id ", i));
            }
        }
        catch (ServiceLocalException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected DeleteAttachmentResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new DeleteAttachmentResponse(this.attachments.get(responseIndex));
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.attachments.size();
    }

    @Override
    protected String getXmlElementName() {
        return "DeleteAttachment";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "DeleteAttachmentResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "DeleteAttachmentResponseMessage";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Messages, "AttachmentIds");
        for (Attachment attachment : this.attachments) {
            writer.writeStartElement(XmlNamespace.Types, "AttachmentId");
            writer.writeAttributeValue("Id", attachment.getId());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }
}

