/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import microsoft.exchange.webservices.data.DnsException;
import microsoft.exchange.webservices.data.DnsRecord;

class DnsSrvRecord
extends DnsRecord {
    private String target;
    private int priority;
    private int weight;
    private int port;

    DnsSrvRecord() {
    }

    protected String getNameTarget() {
        return this.target;
    }

    protected int getPriority() {
        return this.priority;
    }

    protected int getWeight() {
        return this.weight;
    }

    protected int getPort() {
        return this.port;
    }

    @Override
    protected void load(String srvRecord) throws DnsException {
        super.load(null);
        StringTokenizer strTokens = new StringTokenizer(srvRecord);
        try {
            while (strTokens.hasMoreTokens()) {
                String target;
                String priority = strTokens.nextToken();
                this.priority = Integer.parseInt(priority);
                String weight = strTokens.nextToken();
                this.weight = Integer.parseInt(weight);
                String port = strTokens.nextToken();
                this.port = Integer.parseInt(port);
                this.target = target = strTokens.nextToken();
            }
        }
        catch (NumberFormatException ne) {
            throw new DnsException("NumberFormatException " + ne.getMessage());
        }
        catch (NoSuchElementException ne) {
            throw new DnsException("NoSuchElementException " + ne.getMessage());
        }
    }
}

