/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.Recurrence;
import microsoft.exchange.webservices.data.RecurrenceRange;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.XmlNamespace;

final class EndDateRecurrenceRange
extends RecurrenceRange {
    private Date endDate;

    public EndDateRecurrenceRange() {
    }

    public EndDateRecurrenceRange(Date startDate, Date endDate) {
        super(startDate);
        this.endDate = endDate;
    }

    @Override
    protected String getXmlElementName() {
        return "EndDateRecurrence";
    }

    @Override
    protected void setupRecurrence(Recurrence recurrence) throws Exception {
        super.setupRecurrence(recurrence);
        this.endDate = recurrence.getEndDate();
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        Date d = this.endDate;
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        String formattedString = df.format(d);
        super.writeElementsToXml(writer);
        writer.writeElementValue(XmlNamespace.Types, "EndDate", formattedString);
    }

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (super.tryReadElementFromXml(reader)) {
            return true;
        }
        if (reader.getLocalName().equals("EndDate")) {
            Date temp = reader.readElementValueAsDateTime();
            if (temp != null) {
                this.endDate = temp;
            }
            return true;
        }
        return false;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public void setEndDate(Date value) {
        this.canSetFieldValue(this.endDate, value);
    }
}

