/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import microsoft.exchange.webservices.data.AccountIsLockedException;
import microsoft.exchange.webservices.data.EWSHttpException;
import microsoft.exchange.webservices.data.EwsTraceListener;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeCredentials;
import microsoft.exchange.webservices.data.ExchangeServerInfo;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.HttpClientWebRequest;
import microsoft.exchange.webservices.data.HttpWebRequest;
import microsoft.exchange.webservices.data.ICustomXmlSerialization;
import microsoft.exchange.webservices.data.ITraceListener;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.TraceFlags;
import microsoft.exchange.webservices.data.WebProxy;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;

public abstract class ExchangeServiceBase {
    private static final String ExtendedHeaderPrefix = "X-";
    private ExchangeCredentials credentials;
    private boolean useDefaultCredentials;
    private int timeout = 100000;
    private boolean traceEnabled;
    private EnumSet<TraceFlags> traceFlags = EnumSet.allOf(TraceFlags.class);
    private ITraceListener traceListener = new EwsTraceListener();
    private boolean preAuthenticate;
    private String userAgent = defaultUserAgent;
    private boolean acceptGzipEncoding = true;
    private ExchangeVersion requestedServerVersion = ExchangeVersion.Exchange2010_SP1;
    private ExchangeServerInfo serverInfo;
    private Map<String, String> httpHeaders = new HashMap<String, String>();
    private TimeZone timeZone;
    private WebProxy webProxy;
    private HttpConnectionManager simpleHttpConnectionManager = new MultiThreadedHttpConnectionManager();
    private static String defaultUserAgent = "ExchangeServicesClient/" + EwsUtilities.getBuildVersion();
    private List<ICustomXmlSerialization> OnSerializeCustomSoapHeaders;

    protected HttpConnectionManager getSimpleHttpConnectionManager() {
        return this.simpleHttpConnectionManager;
    }

    protected ExchangeServiceBase(ExchangeServiceBase service, ExchangeVersion requestedServerVersion) {
        this(requestedServerVersion);
        this.useDefaultCredentials = service.getUseDefaultCredentials();
        this.credentials = service.getCredentials();
        this.traceEnabled = service.isTraceEnabled();
        this.traceListener = service.getTraceListener();
        this.traceFlags = service.getTraceFlags();
        this.timeout = service.getTimeout();
        this.preAuthenticate = service.isPreAuthenticate();
        this.userAgent = service.getUserAgent();
        this.acceptGzipEncoding = service.getAcceptGzipEncoding();
        this.timeZone = service.getTimeZone();
        this.httpHeaders = service.getHttpHeaders();
    }

    private TimeZone getTimeZone() {
        return this.timeZone;
    }

    protected ExchangeServiceBase(ExchangeServiceBase service) {
        this(service, service.getRequestedServerVersion());
    }

    protected ExchangeServiceBase() {
        this(TimeZone.getDefault());
    }

    protected ExchangeServiceBase(ExchangeVersion requestedServerVersion, TimeZone timeZone) {
        this(timeZone);
        this.requestedServerVersion = requestedServerVersion;
    }

    protected ExchangeServiceBase(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.setUseDefaultCredentials(true);
    }

    protected void doOnSerializeCustomSoapHeaders(XMLStreamWriter writer) {
        EwsUtilities.EwsAssert(writer != null, "ExchangeService.DoOnSerializeCustomSoapHeaders", "writer is null");
        if (null != this.getOnSerializeCustomSoapHeaders() && !this.getOnSerializeCustomSoapHeaders().isEmpty()) {
            for (ICustomXmlSerialization customSerialization : this.getOnSerializeCustomSoapHeaders()) {
                customSerialization.CustomXmlSerialization(writer);
            }
        }
    }

    protected HttpWebRequest prepareHttpWebRequestForUrl(URI url, boolean acceptGzipEncoding, boolean allowAutoRedirect) throws ServiceLocalException, URISyntaxException {
        if (!url.getScheme().equalsIgnoreCase("HTTP") && !url.getScheme().equalsIgnoreCase("HTTPS")) {
            String strErr = String.format(Strings.UnsupportedWebProtocol, url.getScheme());
            throw new ServiceLocalException(strErr);
        }
        HttpClientWebRequest request = new HttpClientWebRequest(this.simpleHttpConnectionManager);
        try {
            request.setUrl(url.toURL());
        }
        catch (MalformedURLException e) {
            String strErr = String.format("Incorrect format : %s", url);
            throw new ServiceLocalException(strErr);
        }
        request.setPreAuthenticate(this.preAuthenticate);
        request.setTimeout(this.timeout);
        request.setContentType("text/xml; charset=utf-8");
        request.setAccept("text/xml");
        request.setUserAgent(this.userAgent);
        request.setAllowAutoRedirect(allowAutoRedirect);
        if (acceptGzipEncoding) {
            request.setAcceptGzipEncoding(acceptGzipEncoding);
        }
        if (this.webProxy != null) {
            request.setProxy(this.webProxy);
        }
        request.setHeaders(this.getHttpHeaders());
        request.setUseDefaultCredentials(this.useDefaultCredentials);
        if (!this.useDefaultCredentials) {
            ExchangeCredentials serviceCredentials = this.credentials;
            if (null == serviceCredentials) {
                throw new ServiceLocalException(Strings.CredentialsRequired);
            }
            serviceCredentials.preAuthenticate();
            serviceCredentials.prepareWebRequest(request);
        }
        try {
            ((HttpWebRequest)request).prepareConnection();
        }
        catch (Exception e) {
            String strErr = String.format("%s : Connection error ", url);
            throw new ServiceLocalException(strErr);
        }
        return request;
    }

    protected void internalProcessHttpErrorResponse(HttpWebRequest httpWebResponse, Exception webException, TraceFlags responseHeadersTraceFlag, TraceFlags responseTraceFlag) throws Exception {
        EwsUtilities.EwsAssert(500 != httpWebResponse.getResponseCode(), "ExchangeServiceBase.InternalProcessHttpErrorResponse", "InternalProcessHttpErrorResponse does not handle 500 ISE errors, the caller is supposed to handle this.");
        this.traceHttpResponseHeaders(responseHeadersTraceFlag, httpWebResponse);
        if (httpWebResponse.getResponseCode() == 456) {
            String location = httpWebResponse.getResponseContentType();
            URI accountUnlockUrl = null;
            if (ExchangeServiceBase.checkURIPath(location)) {
                accountUnlockUrl = new URI(location);
            }
            this.traceMessage(responseTraceFlag, String.format("Account is locked. Unlock URL is {0}", accountUnlockUrl));
            throw new AccountIsLockedException(String.format(Strings.AccountIsLocked, accountUnlockUrl), accountUnlockUrl, webException);
        }
    }

    public static boolean checkURIPath(String location) {
        if (location == null) {
            return false;
        }
        File file = new File(location);
        return file.isAbsolute();
    }

    protected abstract void processHttpErrorResponse(HttpWebRequest var1, Exception var2) throws Exception;

    protected boolean isTraceEnabledFor(TraceFlags traceFlags) {
        return this.isTraceEnabled() && this.traceFlags.contains((Object)traceFlags);
    }

    protected void traceMessage(TraceFlags traceType, String logEntry) throws XMLStreamException, IOException {
        if (this.isTraceEnabledFor(traceType)) {
            String traceTypeStr = traceType.toString();
            String logMessage = EwsUtilities.formatLogMessage(traceTypeStr, logEntry);
            this.traceListener.trace(traceTypeStr, logMessage);
        }
    }

    protected void traceXml(TraceFlags traceType, ByteArrayOutputStream stream) {
        if (this.isTraceEnabledFor(traceType)) {
            String traceTypeStr = traceType.toString();
            String logMessage = EwsUtilities.formatLogMessageWithXmlContent(traceTypeStr, stream);
            this.traceListener.trace(traceTypeStr, logMessage);
        }
    }

    protected void traceHttpRequestHeaders(TraceFlags traceType, HttpWebRequest request) throws URISyntaxException, EWSHttpException, XMLStreamException, IOException {
        if (this.isTraceEnabledFor(traceType)) {
            String traceTypeStr = traceType.toString();
            String headersAsString = EwsUtilities.formatHttpRequestHeaders(request);
            String logMessage = EwsUtilities.formatLogMessage(traceTypeStr, headersAsString);
            this.traceListener.trace(traceTypeStr, logMessage);
        }
    }

    protected void traceHttpResponseHeaders(TraceFlags traceType, HttpWebRequest request) throws XMLStreamException, IOException, EWSHttpException {
        if (this.isTraceEnabledFor(traceType)) {
            String traceTypeStr = traceType.toString();
            String headersAsString = EwsUtilities.formatHttpResponseHeaders(request);
            String logMessage = EwsUtilities.formatLogMessage(traceTypeStr, headersAsString);
            this.traceListener.trace(traceTypeStr, logMessage);
        }
    }

    protected Date convertUniversalDateTimeStringToDate(String dateString) {
        String localTimeRegex = "^(.*)([+-]{1}\\d\\d:\\d\\d)$";
        Pattern localTimePattern = Pattern.compile(localTimeRegex);
        String utcPattern = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        String localPattern = "yyyy-MM-dd'T'HH:mm:ssz";
        String localPattern1 = "yyyy-MM-dd'Z'";
        String pattern = "yyyy-MM-ddz";
        String localPattern2 = "yyyy-MM-dd'T'HH:mm:ss";
        SimpleDateFormat utcFormatter = null;
        Date dt = null;
        String errMsg = String.format("Date String %s not in valid UTC/local format", dateString);
        if (dateString == null || dateString.isEmpty()) {
            return null;
        }
        if (dateString.endsWith("Z")) {
            utcFormatter = new SimpleDateFormat(utcPattern);
            utcFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                dt = utcFormatter.parse(dateString);
            }
            catch (ParseException e) {
                utcFormatter = new SimpleDateFormat(pattern);
                try {
                    dt = utcFormatter.parse(dateString);
                }
                catch (ParseException e1) {
                    utcFormatter = new SimpleDateFormat(localPattern1);
                    try {
                        dt = utcFormatter.parse(dateString);
                    }
                    catch (ParseException e2) {
                        throw new IllegalArgumentException(errMsg, e);
                    }
                }
            }
        } else {
            if (dateString.endsWith("z")) {
                utcFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'z'");
                utcFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
                try {
                    dt = utcFormatter.parse(dateString);
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            Matcher localTimeMatcher = localTimePattern.matcher(dateString);
            if (localTimeMatcher.find()) {
                System.out.println("Pattern matched");
                String date = localTimeMatcher.group(1);
                String zone = localTimeMatcher.group(2);
                dateString = String.format("%sGMT%s", date, zone);
                try {
                    utcFormatter = new SimpleDateFormat(localPattern);
                    dt = utcFormatter.parse(dateString);
                }
                catch (ParseException e) {
                    try {
                        utcFormatter = new SimpleDateFormat(pattern);
                        dt = utcFormatter.parse(dateString);
                    }
                    catch (ParseException ex) {
                        throw new IllegalArgumentException(ex);
                    }
                }
            } else {
                utcFormatter = new SimpleDateFormat(localPattern2);
                try {
                    dt = utcFormatter.parse(dateString);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    throw new IllegalArgumentException(errMsg);
                }
            }
        }
        return dt;
    }

    protected Date convertStartDateToUnspecifiedDateTime(String value) throws ParseException {
        if (value == null || value.isEmpty()) {
            return null;
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'Z'");
        return df.parse(value);
    }

    protected String convertDateTimeToUniversalDateTimeString(Date dt) {
        SimpleDateFormat utcFormatter = null;
        String utcPattern = "yyyy-MM-dd'T'HH:mm:ss'Z'";
        utcFormatter = new SimpleDateFormat(utcPattern);
        utcFormatter.setTimeZone(TimeZone.getTimeZone("UTC"));
        return utcFormatter.format(dt);
    }

    protected void setCustomUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    protected ExchangeServiceBase(ExchangeVersion requestedServerVersion) {
        this.requestedServerVersion = requestedServerVersion;
    }

    protected void validate() throws ServiceLocalException {
        for (Map.Entry<String, String> key : this.httpHeaders.entrySet()) {
            if (key.getKey().startsWith(ExtendedHeaderPrefix)) continue;
            throw new ServiceValidationException(String.format(Strings.CannotAddRequestHeader, key));
        }
    }

    public void setCookie(URL url, String value) throws IOException, URISyntaxException {
        CookieHandler handler = CookieHandler.getDefault();
        if (handler != null) {
            HashMap<String, List<String>> headers = new HashMap<String, List<String>>();
            Vector<String> values = new Vector<String>();
            values.add(value);
            headers.put("Cookie", values);
            handler.put(url.toURI(), headers);
        }
    }

    public String getCookie(URL url) throws IOException, URISyntaxException {
        String cookieValue = null;
        CookieHandler handler = CookieHandler.getDefault();
        if (handler != null) {
            Map<String, List<String>> headers = handler.get(url.toURI(), new HashMap<String, List<String>>());
            List<String> values = headers.get("Cookie");
            for (String v : values) {
                if (cookieValue == null) {
                    cookieValue = v;
                    continue;
                }
                cookieValue = cookieValue + ";" + v;
            }
        }
        return cookieValue;
    }

    public boolean isTraceEnabled() {
        return this.traceEnabled;
    }

    public void setTraceEnabled(boolean traceEnabled) {
        this.traceEnabled = traceEnabled;
        if (this.traceEnabled && this.traceListener == null) {
            this.traceListener = new EwsTraceListener();
        }
    }

    public EnumSet<TraceFlags> getTraceFlags() {
        return this.traceFlags;
    }

    public void setTraceFlags(EnumSet<TraceFlags> traceFlags) {
        this.traceFlags = traceFlags;
    }

    public ITraceListener getTraceListener() {
        return this.traceListener;
    }

    public void setTraceListener(ITraceListener traceListener) {
        this.traceListener = traceListener;
        this.traceEnabled = traceListener != null;
    }

    public ExchangeCredentials getCredentials() {
        return this.credentials;
    }

    public void setCredentials(ExchangeCredentials credentials) {
        this.credentials = credentials;
        this.useDefaultCredentials = false;
        CookieHandler.setDefault(null);
    }

    public boolean getUseDefaultCredentials() {
        return this.useDefaultCredentials;
    }

    public void setUseDefaultCredentials(boolean value) {
        this.useDefaultCredentials = value;
        if (value) {
            this.credentials = null;
            CookieHandler.setDefault(null);
        }
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        if (timeout < 1) {
            throw new IllegalArgumentException(Strings.TimeoutMustBeGreaterThanZero);
        }
        this.timeout = timeout;
    }

    public boolean isPreAuthenticate() {
        return this.preAuthenticate;
    }

    public void setPreAuthenticate(boolean preAuthenticate) {
        this.preAuthenticate = preAuthenticate;
    }

    public boolean getAcceptGzipEncoding() {
        return this.acceptGzipEncoding;
    }

    public void setAcceptGzipEncoding(boolean acceptGzipEncoding) {
        this.acceptGzipEncoding = acceptGzipEncoding;
    }

    public ExchangeVersion getRequestedServerVersion() {
        return this.requestedServerVersion;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent + " (" + defaultUserAgent + ")";
    }

    public ExchangeServerInfo getServerInfo() {
        return this.serverInfo;
    }

    void setServerInfo(ExchangeServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    public WebProxy getWebProxy() {
        return this.webProxy;
    }

    public void setWebProxy(WebProxy value) {
        this.webProxy = value;
    }

    public Map<String, String> getHttpHeaders() {
        return this.httpHeaders;
    }

    public List<ICustomXmlSerialization> getOnSerializeCustomSoapHeaders() {
        return this.OnSerializeCustomSoapHeaders;
    }

    public void setOnSerializeCustomSoapHeaders(List<ICustomXmlSerialization> onSerializeCustomSoapHeaders) {
        this.OnSerializeCustomSoapHeaders = onSerializeCustomSoapHeaders;
    }
}

