/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.FolderIdWrapperList;
import microsoft.exchange.webservices.data.Grouping;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.SearchFilter;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.ServiceVersionException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.ViewBase;
import microsoft.exchange.webservices.data.XmlNamespace;

abstract class FindRequest<TResponse extends ServiceResponse>
extends MultiResponseServiceRequest<TResponse> {
    private FolderIdWrapperList parentFolderIds = new FolderIdWrapperList();
    private SearchFilter searchFilter;
    private String queryString;
    private ViewBase view;

    protected FindRequest(ExchangeService service, ServiceErrorHandling errorHandlingMode) throws Exception {
        super(service, errorHandlingMode);
    }

    @Override
    protected void validate() throws ServiceLocalException, Exception {
        super.validate();
        this.getView().internalValidate(this);
        if (this.queryString != null && !this.queryString.isEmpty() && this.getService().getRequestedServerVersion().ordinal() < ExchangeVersion.Exchange2010.ordinal()) {
            throw new ServiceVersionException(String.format(Strings.ParameterIncompatibleWithRequestVersion, new Object[]{"queryString", ExchangeVersion.Exchange2010}));
        }
        if (this.queryString != null && !this.queryString.isEmpty() && this.searchFilter != null) {
            throw new ServiceLocalException(Strings.BothSearchFilterAndQueryStringCannotBeSpecified);
        }
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return this.getParentFolderIds().getCount();
    }

    protected Grouping getGroupBy() {
        return null;
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        super.writeAttributesToXml(writer);
        this.getView().writeAttributesToXml(writer);
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.getView().writeToXml(writer, this.getGroupBy());
        if (this.getSearchFilter() != null) {
            writer.writeStartElement(XmlNamespace.Messages, "Restriction");
            this.getSearchFilter().writeToXml(writer);
            writer.writeEndElement();
        }
        this.getView().writeOrderByToXml(writer);
        try {
            this.getParentFolderIds().writeToXml(writer, XmlNamespace.Messages, "ParentFolderIds");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.queryString != null && !this.queryString.isEmpty()) {
            writer.writeElementValue(XmlNamespace.Messages, "QueryString", this.queryString);
        }
    }

    public FolderIdWrapperList getParentFolderIds() {
        return this.parentFolderIds;
    }

    public SearchFilter getSearchFilter() {
        return this.searchFilter;
    }

    public void setSearchFilter(SearchFilter searchFilter) {
        this.searchFilter = searchFilter;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public ViewBase getView() {
        return this.view;
    }

    public void setView(ViewBase view) {
        this.view = view;
    }
}

