/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.Date;
import microsoft.exchange.webservices.data.EventType;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.NotificationEvent;
import microsoft.exchange.webservices.data.XmlNamespace;

public class FolderEvent
extends NotificationEvent {
    private FolderId folderId;
    private FolderId oldFolderId;
    private int unreadCount;

    protected FolderEvent(EventType eventType, Date timestamp) {
        super(eventType, timestamp);
    }

    @Override
    protected void internalLoadFromXml(EwsServiceXmlReader reader) throws Exception {
        super.internalLoadFromXml(reader);
        this.folderId = new FolderId();
        this.folderId.loadFromXml(reader, reader.getLocalName());
        reader.read();
        this.setParentFolderId(new FolderId());
        this.getParentFolderId().loadFromXml(reader, "ParentFolderId");
        switch (this.getEventType()) {
            case Moved: 
            case Copied: {
                reader.read();
                this.oldFolderId = new FolderId();
                this.oldFolderId.loadFromXml(reader, reader.getLocalName());
                reader.read();
                this.setParentFolderId(new FolderId());
                this.getParentFolderId().loadFromXml(reader, reader.getLocalName());
                break;
            }
            case Modified: {
                reader.read();
                if (!reader.isStartElement()) break;
                reader.ensureCurrentNodeIsStartElement(XmlNamespace.Types, "UnreadCount");
                String str = reader.readValue();
                this.unreadCount = Integer.parseInt(str);
                break;
            }
        }
    }

    public FolderId getFolderId() {
        return this.folderId;
    }

    public FolderId getOldFolderId() {
        return this.oldFolderId;
    }

    public int getUnreadCount() {
        return this.unreadCount;
    }
}

