/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.ComplexPropertyCollection;
import microsoft.exchange.webservices.data.EditorBrowsable;
import microsoft.exchange.webservices.data.EditorBrowsableState;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.FolderId;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.WellKnownFolderName;

@EditorBrowsable(state=EditorBrowsableState.Never)
public final class FolderIdCollection
extends ComplexPropertyCollection<FolderId> {
    protected FolderIdCollection() {
    }

    @Override
    protected FolderId createComplexProperty(String xmlElementName) {
        return new FolderId();
    }

    public void add(FolderId folderId) throws Exception {
        EwsUtilities.validateParam(folderId, "folderId");
        if (this.contains(folderId)) {
            throw new IllegalArgumentException(Strings.IdAlreadyInList);
        }
        this.internalAdd(folderId);
    }

    @Override
    protected String getCollectionItemXmlElementName(FolderId complexProperty) {
        return complexProperty.getXmlElementName();
    }

    public FolderId add(WellKnownFolderName folderName) {
        FolderId folderId = new FolderId(folderName);
        if (this.contains(folderId)) {
            throw new IllegalArgumentException(Strings.IdAlreadyInList);
        }
        this.internalAdd(folderId);
        return folderId;
    }

    public void clear() {
        this.internalClear();
    }

    public void removeAt(int index) {
        if (index < 0 || index >= this.getCount()) {
            throw new IndexOutOfBoundsException(Strings.IndexIsOutOfRange);
        }
        this.internalRemoveAt(index);
    }

    public boolean remove(FolderId folderId) throws Exception {
        EwsUtilities.validateParam(folderId, "folderId");
        return this.internalRemove(folderId);
    }

    public boolean remove(WellKnownFolderName folderName) {
        FolderId folderId = FolderId.getFolderIdFromWellKnownFolderName(folderName);
        return this.internalRemove(folderId);
    }
}

