/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import microsoft.exchange.webservices.data.CalendarFolder;
import microsoft.exchange.webservices.data.ComplexPropertyCollection;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.Folder;
import microsoft.exchange.webservices.data.FolderPermission;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceValidationException;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class FolderPermissionCollection
extends ComplexPropertyCollection<FolderPermission> {
    private boolean isCalendarFolder;
    private Collection<String> unknownEntries = new ArrayList<String>();

    protected FolderPermissionCollection(Folder owner) {
        this.isCalendarFolder = owner instanceof CalendarFolder;
    }

    private String getInnerCollectionXmlElementName() {
        return this.isCalendarFolder ? "CalendarPermissions" : "Permissions";
    }

    private String getCollectionItemXmlElementName() {
        return this.isCalendarFolder ? "CalendarPermission" : "Permission";
    }

    @Override
    protected String getCollectionItemXmlElementName(FolderPermission complexProperty) {
        return this.getCollectionItemXmlElementName();
    }

    @Override
    protected void loadFromXml(EwsServiceXmlReader reader, String localElementName) throws Exception {
        reader.ensureCurrentNodeIsStartElement(XmlNamespace.Types, localElementName);
        reader.readStartElement(XmlNamespace.Types, this.getInnerCollectionXmlElementName());
        super.loadFromXml(reader, this.getInnerCollectionXmlElementName());
        reader.readEndElementIfNecessary(XmlNamespace.Types, this.getInnerCollectionXmlElementName());
        reader.read();
        if (reader.isStartElement(XmlNamespace.Types, "UnknownEntries")) {
            do {
                reader.read();
                if (!reader.isStartElement(XmlNamespace.Types, "UnknownEntry")) continue;
                this.unknownEntries.add(reader.readElementValue());
            } while (!reader.isEndElement(XmlNamespace.Types, "UnknownEntries"));
        }
    }

    @Override
    public void validate() {
        for (int permissionIndex = 0; permissionIndex < this.getItems().size(); ++permissionIndex) {
            FolderPermission permission = (FolderPermission)this.getItems().get(permissionIndex);
            try {
                permission.validate(this.isCalendarFolder, permissionIndex);
                continue;
            }
            catch (ServiceValidationException e) {
                e.printStackTrace();
                continue;
            }
            catch (ServiceLocalException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        writer.writeStartElement(XmlNamespace.Types, this.getInnerCollectionXmlElementName());
        for (FolderPermission folderPermission : this) {
            folderPermission.writeToXml(writer, this.getCollectionItemXmlElementName(folderPermission), this.isCalendarFolder);
        }
        writer.writeEndElement();
    }

    @Override
    protected FolderPermission createComplexProperty(String xmlElementName) {
        return new FolderPermission();
    }

    public void add(FolderPermission permission) {
        this.internalAdd(permission);
    }

    public void addFolderRange(Iterator<FolderPermission> permissions) throws Exception {
        EwsUtilities.validateParam(permissions, "permissions");
        if (null != permissions) {
            while (permissions.hasNext()) {
                this.add(permissions.next());
            }
        }
    }

    public void clear() {
        this.internalClear();
    }

    public boolean remove(FolderPermission permission) {
        return this.internalRemove(permission);
    }

    public void removeAt(int index) {
        this.internalRemoveAt(index);
    }

    public Collection<String> getUnknownEntries() {
        return this.unknownEntries;
    }
}

