/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.GetStreamingEventsResponse;
import microsoft.exchange.webservices.data.HangingServiceRequestBase;
import microsoft.exchange.webservices.data.ServiceVersionException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.XmlNamespace;

class GetStreamingEventsRequest
extends HangingServiceRequestBase {
    protected static final int HeartbeatFrequencyDefault = 45000;
    private static int heartbeatFrequency = 45000;
    private Iterable<String> subscriptionIds;
    private int connectionTimeout;

    protected GetStreamingEventsRequest(ExchangeService service, HangingServiceRequestBase.IHandleResponseObject serviceObjectHandler, Iterable<String> subscriptionIds, int connectionTimeout) throws ServiceVersionException {
        super(service, serviceObjectHandler, heartbeatFrequency);
        this.subscriptionIds = subscriptionIds;
        this.connectionTimeout = connectionTimeout;
    }

    @Override
    protected String getXmlElementName() {
        return "GetStreamingEvents";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "GetStreamingEventsResponse";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        writer.writeStartElement(XmlNamespace.Messages, "SubscriptionIds");
        for (String id : this.subscriptionIds) {
            writer.writeElementValue(XmlNamespace.Types, "SubscriptionId", id);
        }
        writer.writeEndElement();
        writer.writeElementValue(XmlNamespace.Messages, "ConnectionTimeout", this.connectionTimeout);
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010_SP1;
    }

    @Override
    protected Object parseResponse(EwsServiceXmlReader reader) throws Exception {
        reader.readStartElement(XmlNamespace.Messages, "ResponseMessages");
        GetStreamingEventsResponse response = new GetStreamingEventsResponse(this);
        response.loadFromXml(reader, "GetStreamingEventsResponseMessage");
        reader.readEndElementIfNecessary(XmlNamespace.Messages, "ResponseMessages");
        return response;
    }

    protected static void setHeartbeatFrequency(int heartbeatFrequency) {
        GetStreamingEventsRequest.heartbeatFrequency = heartbeatFrequency;
    }
}

