/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.AggregateType;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ISelfValidate;
import microsoft.exchange.webservices.data.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.SortDirection;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class Grouping
implements ISelfValidate {
    private SortDirection sortDirection = SortDirection.Ascending;
    private PropertyDefinitionBase groupOn;
    private PropertyDefinitionBase aggregateOn;
    private AggregateType aggregateType = AggregateType.Minimum;

    private void internalValidate() throws Exception {
        EwsUtilities.validateParam(this.groupOn, "GroupOn");
        EwsUtilities.validateParam(this.aggregateOn, "AggregateOn");
    }

    public Grouping() {
    }

    public Grouping(PropertyDefinitionBase groupOn, SortDirection sortDirection, PropertyDefinitionBase aggregateOn, AggregateType aggregateType) throws Exception {
        this();
        EwsUtilities.validateParam(groupOn, "groupOn");
        EwsUtilities.validateParam(aggregateOn, "aggregateOn");
        this.groupOn = groupOn;
        this.sortDirection = sortDirection;
        this.aggregateOn = aggregateOn;
        this.aggregateType = aggregateType;
    }

    protected void writeToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeStartElement(XmlNamespace.Messages, "GroupBy");
        writer.writeAttributeValue("Order", (Object)this.sortDirection);
        this.groupOn.writeToXml(writer);
        writer.writeStartElement(XmlNamespace.Types, "AggregateOn");
        writer.writeAttributeValue("Aggregate", (Object)this.aggregateType);
        this.aggregateOn.writeToXml(writer);
        writer.writeEndElement();
        writer.writeEndElement();
    }

    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    public void setSortDirection(SortDirection sortDirection) {
        this.sortDirection = sortDirection;
    }

    public PropertyDefinitionBase getGroupOn() {
        return this.groupOn;
    }

    public void setGroupOn(PropertyDefinitionBase groupOn) {
        this.groupOn = groupOn;
    }

    public PropertyDefinitionBase getAggregateOn() {
        return this.aggregateOn;
    }

    public void setAggregateOn(PropertyDefinitionBase aggregateOn) {
        this.aggregateOn = aggregateOn;
    }

    public AggregateType getAggregateType() {
        return this.aggregateType;
    }

    public void setAggregateType(AggregateType aggregateType) {
        this.aggregateType = aggregateType;
    }

    @Override
    public void validate() {
        try {
            this.internalValidate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

