/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import microsoft.exchange.webservices.data.EditorBrowsable;
import microsoft.exchange.webservices.data.EditorBrowsableState;
import microsoft.exchange.webservices.data.EwsXmlReader;
import microsoft.exchange.webservices.data.GetUserSettingsResponse;
import microsoft.exchange.webservices.data.IFunc;
import microsoft.exchange.webservices.data.ILazyMember;
import microsoft.exchange.webservices.data.LazyMember;
import microsoft.exchange.webservices.data.OutlookProtocolType;
import microsoft.exchange.webservices.data.UserSettingName;
import microsoft.exchange.webservices.data.WebClientUrl;
import microsoft.exchange.webservices.data.WebClientUrlCollection;
import microsoft.exchange.webservices.data.XmlNamespace;

@EditorBrowsable(state=EditorBrowsableState.Never)
final class OutlookProtocol {
    private static final String EXCH = "EXCH";
    private static final String EXPR = "EXPR";
    private static final String WEB = "WEB";
    private static LazyMember<Map<UserSettingName, IFunc<OutlookProtocol, Object>>> commonProtocolSettings = new LazyMember<Map<UserSettingName, IFunc<OutlookProtocol, Object>>>(new ILazyMember<Map<UserSettingName, IFunc<OutlookProtocol, Object>>>(){

        @Override
        public Map<UserSettingName, IFunc<OutlookProtocol, Object>> createInstance() {
            HashMap<UserSettingName, IFunc<OutlookProtocol, Object>> results = new HashMap<UserSettingName, IFunc<OutlookProtocol, Object>>();
            results.put(UserSettingName.EcpDeliveryReportUrlFragment, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.ecpUrlMt;
                }
            });
            results.put(UserSettingName.EcpEmailSubscriptionsUrlFragment, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.ecpUrlAggr;
                }
            });
            results.put(UserSettingName.EcpPublishingUrlFragment, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.ecpUrlPublish;
                }
            });
            results.put(UserSettingName.EcpRetentionPolicyTagsUrlFragment, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.ecpUrlRet;
                }
            });
            results.put(UserSettingName.EcpTextMessagingUrlFragment, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.ecpUrlSms;
                }
            });
            results.put(UserSettingName.EcpVoicemailUrlFragment, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.ecpUrlUm;
                }
            });
            return results;
        }
    });
    private static LazyMember<Map<UserSettingName, IFunc<OutlookProtocol, Object>>> internalProtocolSettings = new LazyMember<Map<UserSettingName, IFunc<OutlookProtocol, Object>>>(new ILazyMember<Map<UserSettingName, IFunc<OutlookProtocol, Object>>>(){

        @Override
        public Map<UserSettingName, IFunc<OutlookProtocol, Object>> createInstance() {
            HashMap<UserSettingName, IFunc<OutlookProtocol, Object>> results = new HashMap<UserSettingName, IFunc<OutlookProtocol, Object>>();
            results.put(UserSettingName.ActiveDirectoryServer, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.activeDirectoryServer;
                }
            });
            results.put(UserSettingName.CrossOrganizationSharingEnabled, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return String.valueOf(arg.sharingEnabled);
                }
            });
            results.put(UserSettingName.InternalEcpUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.ecpUrl;
                }
            });
            results.put(UserSettingName.InternalEcpDeliveryReportUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.convertEcpFragmentToUrl(arg.ecpUrlMt);
                }
            });
            results.put(UserSettingName.InternalEcpEmailSubscriptionsUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.convertEcpFragmentToUrl(arg.ecpUrlAggr);
                }
            });
            results.put(UserSettingName.InternalEcpPublishingUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.convertEcpFragmentToUrl(arg.ecpUrlPublish);
                }
            });
            results.put(UserSettingName.InternalEcpRetentionPolicyTagsUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.convertEcpFragmentToUrl(arg.ecpUrlRet);
                }
            });
            results.put(UserSettingName.InternalEcpTextMessagingUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.convertEcpFragmentToUrl(arg.ecpUrlSms);
                }
            });
            results.put(UserSettingName.InternalEcpVoicemailUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.convertEcpFragmentToUrl(arg.ecpUrlUm);
                }
            });
            results.put(UserSettingName.InternalEwsUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.exchangeWebServicesUrl == null ? arg.availabilityServiceUrl : arg.exchangeWebServicesUrl;
                }
            });
            results.put(UserSettingName.InternalMailboxServerDN, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.serverDN;
                }
            });
            results.put(UserSettingName.InternalRpcClientServer, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.server;
                }
            });
            results.put(UserSettingName.InternalOABUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.offlineAddressBookUrl;
                }
            });
            results.put(UserSettingName.InternalUMUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.unifiedMessagingUrl;
                }
            });
            results.put(UserSettingName.MailboxDN, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.mailboxDN;
                }
            });
            results.put(UserSettingName.PublicFolderServer, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.publicFolderServer;
                }
            });
            return results;
        }
    });
    private static LazyMember<Map<UserSettingName, IFunc<OutlookProtocol, Object>>> externalProtocolSettings = new LazyMember<Map<UserSettingName, IFunc<OutlookProtocol, Object>>>(new ILazyMember<Map<UserSettingName, IFunc<OutlookProtocol, Object>>>(){

        @Override
        public Map<UserSettingName, IFunc<OutlookProtocol, Object>> createInstance() {
            HashMap<UserSettingName, IFunc<OutlookProtocol, Object>> results = new HashMap<UserSettingName, IFunc<OutlookProtocol, Object>>();
            results.put(UserSettingName.ExternalEcpDeliveryReportUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.convertEcpFragmentToUrl(arg.ecpUrlRet);
                }
            });
            results.put(UserSettingName.ExternalEcpEmailSubscriptionsUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.convertEcpFragmentToUrl(arg.ecpUrlAggr);
                }
            });
            results.put(UserSettingName.ExternalEcpPublishingUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.convertEcpFragmentToUrl(arg.ecpUrlPublish);
                }
            });
            results.put(UserSettingName.ExternalEcpRetentionPolicyTagsUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.convertEcpFragmentToUrl(arg.ecpUrlRet);
                }
            });
            results.put(UserSettingName.ExternalEcpTextMessagingUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.convertEcpFragmentToUrl(arg.ecpUrlSms);
                }
            });
            results.put(UserSettingName.ExternalEcpUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.ecpUrl;
                }
            });
            results.put(UserSettingName.ExternalEcpVoicemailUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.convertEcpFragmentToUrl(arg.ecpUrlUm);
                }
            });
            results.put(UserSettingName.ExternalEwsUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.exchangeWebServicesUrl == null ? arg.availabilityServiceUrl : arg.exchangeWebServicesUrl;
                }
            });
            results.put(UserSettingName.ExternalMailboxServer, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.server;
                }
            });
            results.put(UserSettingName.ExternalMailboxServerAuthenticationMethods, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.authPackage;
                }
            });
            results.put(UserSettingName.ExternalMailboxServerRequiresSSL, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return String.valueOf(arg.sslEnabled);
                }
            });
            results.put(UserSettingName.ExternalOABUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.offlineAddressBookUrl;
                }
            });
            results.put(UserSettingName.ExternalUMUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.unifiedMessagingUrl;
                }
            });
            results.put(UserSettingName.ExchangeRpcUrl, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.exchangeRpcUrl;
                }
            });
            return results;
        }
    });
    private static LazyMember<Map<UserSettingName, IFunc<OutlookProtocol, Object>>> internalProtocolConverterDictionary = new LazyMember<Map<UserSettingName, IFunc<OutlookProtocol, Object>>>(new ILazyMember<Map<UserSettingName, IFunc<OutlookProtocol, Object>>>(){

        @Override
        public Map<UserSettingName, IFunc<OutlookProtocol, Object>> createInstance() {
            HashMap<UserSettingName, IFunc<OutlookProtocol, Object>> results = new HashMap<UserSettingName, IFunc<OutlookProtocol, Object>>();
            for (Map.Entry kv : ((Map)commonProtocolSettings.getMember()).entrySet()) {
                results.put((UserSettingName)((Object)kv.getKey()), (IFunc<OutlookProtocol, Object>)kv.getValue());
            }
            for (Map.Entry kv : ((Map)internalProtocolSettings.getMember()).entrySet()) {
                results.put((UserSettingName)((Object)kv.getKey()), (IFunc<OutlookProtocol, Object>)kv.getValue());
            }
            return results;
        }
    });
    private static LazyMember<Map<UserSettingName, IFunc<OutlookProtocol, Object>>> externalProtocolConverterDictionary = new LazyMember<Map<UserSettingName, IFunc<OutlookProtocol, Object>>>(new ILazyMember<Map<UserSettingName, IFunc<OutlookProtocol, Object>>>(){

        @Override
        public Map<UserSettingName, IFunc<OutlookProtocol, Object>> createInstance() {
            HashMap<UserSettingName, IFunc<OutlookProtocol, Object>> results = new HashMap<UserSettingName, IFunc<OutlookProtocol, Object>>();
            for (Map.Entry kv : ((Map)commonProtocolSettings.getMember()).entrySet()) {
                results.put((UserSettingName)((Object)kv.getKey()), (IFunc<OutlookProtocol, Object>)kv.getValue());
            }
            for (Map.Entry kv : ((Map)externalProtocolSettings.getMember()).entrySet()) {
                results.put((UserSettingName)((Object)kv.getKey()), (IFunc<OutlookProtocol, Object>)kv.getValue());
            }
            return results;
        }
    });
    private static LazyMember<Map<UserSettingName, IFunc<OutlookProtocol, Object>>> webProtocolConverterDictionary = new LazyMember<Map<UserSettingName, IFunc<OutlookProtocol, Object>>>(new ILazyMember<Map<UserSettingName, IFunc<OutlookProtocol, Object>>>(){

        @Override
        public Map<UserSettingName, IFunc<OutlookProtocol, Object>> createInstance() {
            HashMap<UserSettingName, IFunc<OutlookProtocol, Object>> results = new HashMap<UserSettingName, IFunc<OutlookProtocol, Object>>();
            results.put(UserSettingName.InternalWebClientUrls, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.internalOutlookWebAccessUrls;
                }
            });
            results.put(UserSettingName.ExternalWebClientUrls, new IFunc<OutlookProtocol, Object>(){

                @Override
                public Object func(OutlookProtocol arg) {
                    return arg.externalOutlookWebAccessUrls;
                }
            });
            return results;
        }
    });
    private static LazyMember<List<UserSettingName>> availableUserSettings = new LazyMember<List<UserSettingName>>(new ILazyMember<List<UserSettingName>>(){

        @Override
        public List<UserSettingName> createInstance() {
            ArrayList<UserSettingName> results = new ArrayList<UserSettingName>();
            results.addAll(((Map)commonProtocolSettings.getMember()).keySet());
            results.addAll(((Map)internalProtocolSettings.getMember()).keySet());
            results.addAll(((Map)externalProtocolSettings.getMember()).keySet());
            results.addAll(((Map)webProtocolConverterDictionary.getMember()).keySet());
            return results;
        }
    });
    private static LazyMember<Map<String, OutlookProtocolType>> protocolNameToTypeMap = new LazyMember<Map<String, OutlookProtocolType>>(new ILazyMember<Map<String, OutlookProtocolType>>(){

        @Override
        public Map<String, OutlookProtocolType> createInstance() {
            HashMap<String, OutlookProtocolType> results = new HashMap<String, OutlookProtocolType>();
            results.put(OutlookProtocol.EXCH, OutlookProtocolType.Rpc);
            results.put(OutlookProtocol.EXPR, OutlookProtocolType.RpcOverHttp);
            results.put(OutlookProtocol.WEB, OutlookProtocolType.Web);
            return results;
        }
    });
    private String activeDirectoryServer;
    private String authPackage;
    private String availabilityServiceUrl;
    private String ecpUrl;
    private String ecpUrlAggr;
    private String ecpUrlMt;
    private String ecpUrlPublish;
    private String ecpUrlRet;
    private String ecpUrlSms;
    private String ecpUrlUm;
    private String exchangeWebServicesUrl;
    private String mailboxDN;
    private String offlineAddressBookUrl;
    private String exchangeRpcUrl;
    private String publicFolderServer;
    private String server;
    private String serverDN;
    private String unifiedMessagingUrl;
    private boolean sharingEnabled;
    private boolean sslEnabled;
    private WebClientUrlCollection externalOutlookWebAccessUrls;
    private WebClientUrlCollection internalOutlookWebAccessUrls = new WebClientUrlCollection();
    private OutlookProtocolType protocolType;

    protected OutlookProtocol() {
        this.externalOutlookWebAccessUrls = new WebClientUrlCollection();
    }

    protected void loadFromXml(EwsXmlReader reader) throws Exception {
        do {
            reader.read();
            if (reader.getNodeType().getNodeType() != 1) continue;
            if (reader.getLocalName().equals("Type")) {
                this.setProtocolType(OutlookProtocol.protocolNameToType(reader.readElementValue()));
                continue;
            }
            if (reader.getLocalName().equals("AuthPackage")) {
                this.authPackage = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("Server")) {
                this.server = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("ServerDN")) {
                this.serverDN = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("ServerVersion")) {
                reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("AD")) {
                this.activeDirectoryServer = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("MdbDN")) {
                this.mailboxDN = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("EWSUrl")) {
                this.exchangeWebServicesUrl = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("ASUrl")) {
                this.availabilityServiceUrl = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("OOFUrl")) {
                reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("UMUrl")) {
                this.unifiedMessagingUrl = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("OABUrl")) {
                this.offlineAddressBookUrl = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("PublicFolderServer")) {
                this.publicFolderServer = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("Internal")) {
                OutlookProtocol.loadWebClientUrlsFromXml(reader, this.internalOutlookWebAccessUrls, reader.getLocalName());
                continue;
            }
            if (reader.getLocalName().equals("External")) {
                OutlookProtocol.loadWebClientUrlsFromXml(reader, this.externalOutlookWebAccessUrls, reader.getLocalName());
                continue;
            }
            if (reader.getLocalName().equals("SSL")) {
                String sslStr = reader.readElementValue();
                this.sslEnabled = sslStr.equalsIgnoreCase("On");
                continue;
            }
            if (reader.getLocalName().equals("SharingUrl")) {
                this.sharingEnabled = reader.readElementValue().length() > 0;
                continue;
            }
            if (reader.getLocalName().equals("EcpUrl")) {
                this.ecpUrl = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("EcpUrl-um")) {
                this.ecpUrlUm = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("EcpUrl-aggr")) {
                this.ecpUrlAggr = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("EcpUrl-sms")) {
                this.ecpUrlSms = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("EcpUrl-mt")) {
                this.ecpUrlMt = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("EcpUrl-ret")) {
                this.ecpUrlRet = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("EcpUrl-publish")) {
                this.ecpUrlPublish = reader.readElementValue();
                continue;
            }
            if (reader.getLocalName().equals("ExchangeRpcUrl")) {
                this.exchangeRpcUrl = reader.readElementValue();
                continue;
            }
            reader.skipCurrentElement();
        } while (!reader.isEndElement(XmlNamespace.NotSpecified, "Protocol"));
    }

    private static OutlookProtocolType protocolNameToType(String protocolName) {
        OutlookProtocolType protocolType = null;
        protocolType = !protocolNameToTypeMap.getMember().containsKey(protocolName) ? OutlookProtocolType.Unknown : protocolNameToTypeMap.getMember().get(protocolName);
        return protocolType;
    }

    private static void loadWebClientUrlsFromXml(EwsXmlReader reader, WebClientUrlCollection webClientUrls, String elementName) throws Exception {
        do {
            reader.read();
            if (reader.getNodeType().getNodeType() != 1) continue;
            if (reader.getLocalName().equals("OWAUrl")) {
                String authMethod = reader.readAttributeValue("AuthenticationMethod");
                String owaUrl = reader.readElementValue();
                WebClientUrl webClientUrl = new WebClientUrl(authMethod, owaUrl);
                webClientUrls.getUrls().add(webClientUrl);
                continue;
            }
            reader.skipCurrentElement();
        } while (!reader.isEndElement(XmlNamespace.NotSpecified, elementName));
    }

    private String convertEcpFragmentToUrl(String fragment) {
        return this.ecpUrl == null || this.ecpUrl.isEmpty() || fragment == null || fragment.isEmpty() ? null : this.ecpUrl + fragment;
    }

    protected void convertToUserSettings(List<UserSettingName> requestedSettings, GetUserSettingsResponse response) {
        if (this.getConverterDictionary() != null) {
            HashMap<UserSettingName, IFunc<OutlookProtocol, Object>> converterQuery = new HashMap<UserSettingName, IFunc<OutlookProtocol, Object>>();
            Map<UserSettingName, IFunc<OutlookProtocol, Object>> t = this.getConverterDictionary();
            for (Map.Entry<UserSettingName, IFunc<OutlookProtocol, Object>> entry : t.entrySet()) {
                if (!requestedSettings.contains((Object)entry.getKey())) continue;
                converterQuery.put(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<UserSettingName, IFunc<OutlookProtocol, Object>> entry : converterQuery.entrySet()) {
                Object value = entry.getValue().func(this);
                if (value == null) continue;
                response.getSettings().put(entry.getKey(), value);
            }
        }
    }

    protected OutlookProtocolType getProtocolType() {
        return this.protocolType;
    }

    protected void setProtocolType(OutlookProtocolType protocolType) {
        this.protocolType = protocolType;
    }

    private Map<UserSettingName, IFunc<OutlookProtocol, Object>> getConverterDictionary() {
        switch (this.getProtocolType()) {
            case Rpc: {
                return internalProtocolConverterDictionary.getMember();
            }
            case RpcOverHttp: {
                return externalProtocolConverterDictionary.getMember();
            }
            case Web: {
                return webProtocolConverterDictionary.getMember();
            }
        }
        return null;
    }

    protected static List<UserSettingName> getAvailableUserSettings() {
        return availableUserSettings.getMember();
    }
}

