/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.ConnectionFailureCause;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.PhoneCallId;
import microsoft.exchange.webservices.data.PhoneCallState;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.Strings;

public final class PhoneCall
extends ComplexProperty {
    private static final String SuccessfullResponseText = "OK";
    private static final int SuccessfullResponseCode = 200;
    private ExchangeService service;
    private PhoneCallState state;
    private ConnectionFailureCause connectionFailureCause;
    private String sipResponseText;
    private int sipResponseCode;
    private PhoneCallId id;

    protected PhoneCall(ExchangeService service) {
        EwsUtilities.EwsAssert(service != null, "PhoneCall.ctor", "service is null");
        this.service = service;
        this.state = PhoneCallState.Connecting;
        this.connectionFailureCause = ConnectionFailureCause.None;
        this.sipResponseText = SuccessfullResponseText;
        this.sipResponseCode = 200;
    }

    protected PhoneCall(ExchangeService service, PhoneCallId id) {
        this(service);
        this.id = id;
    }

    public void refresh() throws Exception {
        PhoneCall phoneCall = this.service.getUnifiedMessaging().getPhoneCallInformation(this.id);
        this.state = phoneCall.getState();
        this.connectionFailureCause = phoneCall.getConnectionFailureCause();
        this.sipResponseText = phoneCall.getSipResponseText();
        this.sipResponseCode = phoneCall.getSipResponseCode();
    }

    public void disconnect() throws Exception {
        if (this.state == PhoneCallState.Disconnected) {
            throw new ServiceLocalException(Strings.PhoneCallAlreadyDisconnected);
        }
        this.service.getUnifiedMessaging().disconnectPhoneCall(this.id);
        this.state = PhoneCallState.Disconnected;
    }

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("PhoneCallState")) {
            this.state = reader.readElementValue(PhoneCallState.class);
            return true;
        }
        if (reader.getLocalName().equals("ConnectionFailureCause")) {
            this.connectionFailureCause = reader.readElementValue(ConnectionFailureCause.class);
            return true;
        }
        if (reader.getLocalName().equals("SIPResponseText")) {
            this.sipResponseText = reader.readElementValue();
            return true;
        }
        if (reader.getLocalName().equals("SIPResponseCode")) {
            this.sipResponseCode = reader.readElementValue(Integer.class);
            return true;
        }
        return false;
    }

    public PhoneCallState getState() {
        return this.state;
    }

    public String getSipResponseText() {
        return this.sipResponseText;
    }

    public int getSipResponseCode() {
        return this.sipResponseCode;
    }

    public ConnectionFailureCause getConnectionFailureCause() {
        return this.connectionFailureCause;
    }
}

