/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.ItemId;
import microsoft.exchange.webservices.data.PlayOnPhoneResponse;
import microsoft.exchange.webservices.data.SimpleServiceRequestBase;
import microsoft.exchange.webservices.data.XmlNamespace;

final class PlayOnPhoneRequest
extends SimpleServiceRequestBase {
    private ItemId itemId;
    private String dialString;

    protected PlayOnPhoneRequest(ExchangeService service) throws Exception {
        super(service);
    }

    @Override
    protected String getXmlElementName() {
        return "PlayOnPhone";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.itemId.writeToXml(writer, XmlNamespace.Messages, "ItemId");
        writer.writeElementValue(XmlNamespace.Messages, "DialString", this.dialString);
    }

    @Override
    protected String getResponseXmlElementName() {
        return "PlayOnPhoneResponse";
    }

    @Override
    protected Object parseResponse(EwsServiceXmlReader reader) throws Exception {
        PlayOnPhoneResponse serviceResponse = new PlayOnPhoneResponse(this.getService());
        serviceResponse.loadFromXml(reader, "PlayOnPhoneResponse");
        return serviceResponse;
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010;
    }

    protected PlayOnPhoneResponse execute() throws Exception {
        PlayOnPhoneResponse serviceResponse = (PlayOnPhoneResponse)this.internalExecute();
        serviceResponse.throwIfNecessary();
        return serviceResponse;
    }

    protected ItemId getItemId() {
        return this.itemId;
    }

    protected void setItemId(ItemId itemId) {
        this.itemId = itemId;
    }

    protected String getDialString() {
        return this.dialString;
    }

    protected void setDialString(String dialString) {
        this.dialString = dialString;
    }
}

