/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.EnumSet;
import microsoft.exchange.webservices.data.EndDateRecurrenceRange;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.NoEndRecurrenceRange;
import microsoft.exchange.webservices.data.NumberedRecurrenceRange;
import microsoft.exchange.webservices.data.PropertyBag;
import microsoft.exchange.webservices.data.PropertyDefinition;
import microsoft.exchange.webservices.data.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.Recurrence;
import microsoft.exchange.webservices.data.RecurrenceRange;
import microsoft.exchange.webservices.data.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.XMLNodeType;
import microsoft.exchange.webservices.data.XmlNamespace;

public class RecurrencePropertyDefinition
extends PropertyDefinition {
    protected RecurrencePropertyDefinition(String xmlElementName, String uri, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version) {
        super(xmlElementName, uri, flags, version);
    }

    @Override
    protected void loadPropertyValueFromXml(EwsServiceXmlReader reader, PropertyBag propertyBag) throws Exception {
        RecurrenceRange range;
        reader.ensureCurrentNodeIsStartElement(XmlNamespace.Types, "Recurrence");
        Recurrence recurrence = null;
        reader.read(new XMLNodeType(1));
        if (reader.getLocalName().equals("RelativeYearlyRecurrence")) {
            recurrence = new Recurrence.RelativeYearlyPattern();
        } else if (reader.getLocalName().equals("AbsoluteYearlyRecurrence")) {
            recurrence = new Recurrence.YearlyPattern();
        } else if (reader.getLocalName().equals("RelativeMonthlyRecurrence")) {
            recurrence = new Recurrence.RelativeMonthlyPattern();
        } else if (reader.getLocalName().equals("AbsoluteMonthlyRecurrence")) {
            recurrence = new Recurrence.MonthlyPattern();
        } else if (reader.getLocalName().equals("DailyRecurrence")) {
            recurrence = new Recurrence.DailyPattern();
        } else if (reader.getLocalName().equals("DailyRegeneration")) {
            recurrence = new Recurrence.DailyRegenerationPattern();
        } else if (reader.getLocalName().equals("WeeklyRecurrence")) {
            recurrence = new Recurrence.WeeklyPattern();
        } else if (reader.getLocalName().equals("WeeklyRegeneration")) {
            recurrence = new Recurrence.WeeklyRegenerationPattern();
        } else if (reader.getLocalName().equals("MonthlyRegeneration")) {
            recurrence = new Recurrence.MonthlyRegenerationPattern();
        } else if (reader.getLocalName().equals("YearlyRegeneration")) {
            recurrence = new Recurrence.YearlyRegenerationPattern();
        } else {
            throw new ServiceXmlDeserializationException(String.format(Strings.InvalidRecurrencePattern, reader.getLocalName()));
        }
        recurrence.loadFromXml(reader, reader.getLocalName());
        reader.read(new XMLNodeType(1));
        if (reader.getLocalName().equals("NoEndRecurrence")) {
            range = new NoEndRecurrenceRange();
        } else if (reader.getLocalName().equals("EndDateRecurrence")) {
            range = new EndDateRecurrenceRange();
        } else if (reader.getLocalName().equals("NumberedRecurrence")) {
            range = new NumberedRecurrenceRange();
        } else {
            throw new ServiceXmlDeserializationException(String.format(Strings.InvalidRecurrenceRange, reader.getLocalName()));
        }
        range.loadFromXml(reader, reader.getLocalName());
        range.setupRecurrence(recurrence);
        reader.readEndElementIfNecessary(XmlNamespace.Types, "Recurrence");
        propertyBag.setObjectFromPropertyDefinition(this, recurrence);
    }

    @Override
    protected void writePropertyValueToXml(EwsServiceXmlWriter writer, PropertyBag propertyBag, boolean isUpdateOperation) throws Exception {
        Recurrence value = (Recurrence)propertyBag.getObjectFromPropertyDefinition(this);
        if (value != null) {
            value.writeToXml(writer, "Recurrence");
        }
    }

    @Override
    public Class getType() {
        return Recurrence.class;
    }
}

