/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EmailAddressCollection;
import microsoft.exchange.webservices.data.EmailMessage;
import microsoft.exchange.webservices.data.EmailMessageSchema;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.Item;
import microsoft.exchange.webservices.data.ItemSchema;
import microsoft.exchange.webservices.data.MessageBody;
import microsoft.exchange.webservices.data.ResponseMessageSchema;
import microsoft.exchange.webservices.data.ResponseMessageType;
import microsoft.exchange.webservices.data.ResponseObject;
import microsoft.exchange.webservices.data.ResponseObjectSchema;
import microsoft.exchange.webservices.data.ServiceObjectSchema;

public final class ResponseMessage
extends ResponseObject<EmailMessage> {
    private ResponseMessageType responseType;

    ResponseMessage(Item referenceItem, ResponseMessageType responseType) throws Exception {
        super(referenceItem);
        this.responseType = responseType;
    }

    @Override
    protected ServiceObjectSchema getSchema() {
        return ResponseMessageSchema.Instance;
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    @Override
    protected String getXmlElementNameOverride() {
        if (this.responseType == ResponseMessageType.Reply) {
            return "ReplyToItem";
        }
        if (this.responseType == ResponseMessageType.ReplyAll) {
            return "ReplyAllToItem";
        }
        if (this.responseType == ResponseMessageType.Forward) {
            return "ForwardItem";
        }
        EwsUtilities.EwsAssert(false, "ResponseMessage.GetXmlElementNameOverride", "An unexpected value for responseType could not be handled.");
        return null;
    }

    public ResponseMessageType getResponseType() {
        return this.responseType;
    }

    public MessageBody getBody() throws Exception {
        return (MessageBody)this.getObjectFromPropertyDefinition(ItemSchema.Body);
    }

    public void setBody(MessageBody value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ItemSchema.Body, value);
    }

    public EmailAddressCollection getToRecipients() throws Exception {
        return (EmailAddressCollection)this.getObjectFromPropertyDefinition(EmailMessageSchema.ToRecipients);
    }

    public EmailAddressCollection getCcRecipients() throws Exception {
        return (EmailAddressCollection)this.getObjectFromPropertyDefinition(EmailMessageSchema.CcRecipients);
    }

    public EmailAddressCollection getBccRecipients() throws Exception {
        return (EmailAddressCollection)this.getObjectFromPropertyDefinition(EmailMessageSchema.BccRecipients);
    }

    public String getSubject() throws Exception {
        return (String)this.getObjectFromPropertyDefinition(EmailMessageSchema.Subject);
    }

    public void setSubject(String value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(EmailMessageSchema.Subject, value);
    }

    public MessageBody getBodyPrefix() throws Exception {
        return (MessageBody)this.getObjectFromPropertyDefinition(ResponseObjectSchema.BodyPrefix);
    }

    public void setBodyPrefix(MessageBody value) throws Exception {
        this.getPropertyBag().setObjectFromPropertyDefinition(ResponseObjectSchema.BodyPrefix, value);
    }
}

