/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.RuleActions;
import microsoft.exchange.webservices.data.RulePredicates;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class Rule
extends ComplexProperty {
    private String ruleId;
    private String displayName;
    private int priority = 1;
    private boolean isEnabled = true;
    private boolean isNotSupported;
    private boolean isInError;
    private RulePredicates conditions = new RulePredicates();
    private RuleActions actions = new RuleActions();
    private RulePredicates exceptions = new RulePredicates();

    public String getId() {
        return this.ruleId;
    }

    public void setId(String value) {
        if (this.canSetFieldValue(this.ruleId, value)) {
            this.ruleId = value;
            this.changed();
        }
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String value) {
        if (this.canSetFieldValue(this.displayName, value)) {
            this.displayName = value;
            this.changed();
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public void setPriority(int value) {
        if (this.canSetFieldValue(this.priority, value)) {
            this.priority = value;
            this.changed();
        }
    }

    public boolean getIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(boolean value) {
        if (this.canSetFieldValue(this.isEnabled, value)) {
            this.isEnabled = value;
            this.changed();
        }
    }

    public boolean getIsNotSupported() {
        return this.isNotSupported;
    }

    public boolean getIsInError() {
        return this.isInError;
    }

    public void setIsInError(boolean value) {
        if (this.canSetFieldValue(this.isInError, value)) {
            this.isInError = value;
            this.changed();
        }
    }

    public RulePredicates getConditions() {
        return this.conditions;
    }

    public RuleActions getActions() {
        return this.actions;
    }

    public RulePredicates getExceptions() {
        return this.exceptions;
    }

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("DisplayName")) {
            this.displayName = reader.readElementValue();
            return true;
        }
        if (reader.getLocalName().equals("RuleId")) {
            this.ruleId = reader.readElementValue();
            return true;
        }
        if (reader.getLocalName().equals("Priority")) {
            this.priority = reader.readElementValue(Integer.class);
            return true;
        }
        if (reader.getLocalName().equals("IsEnabled")) {
            this.isEnabled = reader.readElementValue(Boolean.class);
            return true;
        }
        if (reader.getLocalName().equals("IsNotSupported")) {
            this.isNotSupported = reader.readElementValue(Boolean.class);
            return true;
        }
        if (reader.getLocalName().equals("IsInError")) {
            this.isInError = reader.readElementValue(Boolean.class);
            return true;
        }
        if (reader.getLocalName().equals("Conditions")) {
            this.conditions.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equals("Actions")) {
            this.actions.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        if (reader.getLocalName().equals("Exceptions")) {
            this.exceptions.loadFromXml(reader, reader.getLocalName());
            return true;
        }
        return false;
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        if (this.getId() != null && !this.getId().isEmpty()) {
            writer.writeElementValue(XmlNamespace.Types, "RuleId", this.getId());
        }
        writer.writeElementValue(XmlNamespace.Types, "DisplayName", this.getDisplayName());
        writer.writeElementValue(XmlNamespace.Types, "Priority", this.getPriority());
        writer.writeElementValue(XmlNamespace.Types, "IsEnabled", this.getIsEnabled());
        writer.writeElementValue(XmlNamespace.Types, "IsInError", this.getIsInError());
        this.getConditions().writeToXml(writer, "Conditions");
        this.getExceptions().writeToXml(writer, "Exceptions");
        this.getActions().writeToXml(writer, "Actions");
    }

    @Override
    protected void internalValidate() throws Exception {
        super.internalValidate();
        EwsUtilities.validateParam(this.displayName, "DisplayName");
        EwsUtilities.validateParam(this.conditions, "Conditions");
        EwsUtilities.validateParam(this.exceptions, "Exceptions");
        EwsUtilities.validateParam(this.actions, "Actions");
    }
}

