/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.EnumSet;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.AppointmentSchema;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.MeetingTimeZone;
import microsoft.exchange.webservices.data.PropertyBag;
import microsoft.exchange.webservices.data.PropertyDefinition;
import microsoft.exchange.webservices.data.PropertyDefinitionFlags;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.TimeZoneDefinition;
import microsoft.exchange.webservices.data.TimeZonePropertyDefinition;

class StartTimeZonePropertyDefinition
extends TimeZonePropertyDefinition {
    protected StartTimeZonePropertyDefinition(String xmlElementName, String uri, EnumSet<PropertyDefinitionFlags> flags, ExchangeVersion version) {
        super(xmlElementName, uri, flags, version);
    }

    @Override
    protected void registerAssociatedInternalProperties(List<PropertyDefinition> properties) {
        super.registerAssociatedInternalProperties(properties);
        properties.add(AppointmentSchema.MeetingTimeZone);
    }

    @Override
    protected void writePropertyValueToXml(EwsServiceXmlWriter writer, PropertyBag propertyBag, boolean isUpdateOperation) throws Exception {
        Object value = propertyBag.getObjectFromPropertyDefinition(this);
        if (value != null) {
            if (writer.getService().getRequestedServerVersion() == ExchangeVersion.Exchange2007_SP1) {
                ExchangeService service = (ExchangeService)writer.getService();
                if (service != null && !service.getExchange2007CompatibilityMode()) {
                    MeetingTimeZone meetingTimeZone = new MeetingTimeZone((TimeZoneDefinition)value);
                    meetingTimeZone.writeToXml(writer, "MeetingTimeZone");
                }
            } else {
                super.writePropertyValueToXml(writer, propertyBag, isUpdateOperation);
            }
        }
    }

    @Override
    protected void writeToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        if (writer.getService().getRequestedServerVersion() == ExchangeVersion.Exchange2007_SP1) {
            AppointmentSchema.MeetingTimeZone.writeToXml(writer);
        } else {
            super.writeToXml(writer);
        }
    }

    @Override
    protected boolean hasFlag(PropertyDefinitionFlags flag, ExchangeVersion version) {
        if (version != null && version == ExchangeVersion.Exchange2007_SP1) {
            return AppointmentSchema.MeetingTimeZone.hasFlag(flag, version);
        }
        return super.hasFlag(flag, version);
    }
}

