/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.XmlNamespace;

public class StringList
extends ComplexProperty
implements Iterable<String> {
    private List<String> items = new ArrayList<String>();
    private String itemXmlElementName = "String";

    public StringList() {
    }

    public StringList(Iterable<String> strings) {
        this.addRange(strings);
    }

    protected StringList(String itemXmlElementName) {
        this.itemXmlElementName = itemXmlElementName;
    }

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws XMLStreamException, ServiceXmlDeserializationException {
        if (reader.getLocalName().equals(this.itemXmlElementName)) {
            this.add(reader.readValue());
            return true;
        }
        return false;
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException, XMLStreamException {
        for (String item : this.items) {
            writer.writeStartElement(XmlNamespace.Types, this.itemXmlElementName);
            writer.writeValue(item, this.itemXmlElementName);
            writer.writeEndElement();
        }
    }

    public void add(String s) {
        this.items.add(s);
        this.changed();
    }

    public void addRange(Iterable<String> strings) {
        boolean changed = false;
        for (String s : strings) {
            if (this.contains(s)) continue;
            this.items.add(s);
            changed = true;
        }
        if (changed) {
            this.changed();
        }
    }

    public boolean contains(String s) {
        return this.items.contains(s);
    }

    public boolean remove(String s) {
        boolean result = this.items.remove(s);
        if (result) {
            this.changed();
        }
        return result;
    }

    public void removeAt(int index) {
        if (index < 0 || index >= this.getSize()) {
            throw new ArrayIndexOutOfBoundsException(Strings.IndexIsOutOfRange);
        }
        this.items.remove(index);
        this.changed();
    }

    public void clearList() {
        this.items.clear();
        this.changed();
    }

    public String toString() {
        StringBuffer temp = new StringBuffer();
        for (String str : this.items) {
            temp.append(str.concat(","));
        }
        String tempString = temp.toString();
        return tempString;
    }

    public int getSize() {
        return this.items.size();
    }

    public String getString(int index) {
        if (index < 0 || index >= this.getSize()) {
            throw new ArrayIndexOutOfBoundsException(Strings.IndexIsOutOfRange);
        }
        return this.items.get(index);
    }

    public void setString(int index, Object object) {
        if (index < 0 || index >= this.getSize()) {
            throw new ArrayIndexOutOfBoundsException(Strings.IndexIsOutOfRange);
        }
        if (this.items.get(index) != object) {
            this.items.set(index, (String)object);
            this.changed();
        }
    }

    public Iterator<String> getIterator() {
        return this.items.iterator();
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringList) {
            StringList other = (StringList)obj;
            return this.toString().equals(other.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public Iterator<String> iterator() {
        return this.items.iterator();
    }
}

