/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.net.URI;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.ArgumentException;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.PushSubscription;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.SubscribeRequest;
import microsoft.exchange.webservices.data.SubscribeResponse;
import microsoft.exchange.webservices.data.XmlNamespace;

class SubscribeToPushNotificationsRequest
extends SubscribeRequest<PushSubscription> {
    private int frequency = 30;
    private URI url;

    protected SubscribeToPushNotificationsRequest(ExchangeService service) throws Exception {
        super(service);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParam(this.getUrl(), "Url");
        if (this.getFrequency() < 1 || this.getFrequency() > 1440) {
            throw new ArgumentException(String.format(Strings.InvalidFrequencyValue, this.getFrequency()));
        }
    }

    @Override
    protected String getSubscriptionXmlElementName() {
        return "PushSubscriptionRequest";
    }

    @Override
    protected void internalWriteElementsToXml(EwsServiceXmlWriter writer) throws XMLStreamException, ServiceXmlSerializationException {
        writer.writeElementValue(XmlNamespace.Types, "StatusFrequency", this.getFrequency());
        writer.writeElementValue(XmlNamespace.Types, "URL", this.getUrl().toString());
    }

    @Override
    protected SubscribeResponse<PushSubscription> createServiceResponse(ExchangeService service, int responseIndex) throws Exception {
        return new SubscribeResponse<PushSubscription>(new PushSubscription(service));
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int frequency) {
        this.frequency = frequency;
    }

    public URI getUrl() {
        return this.url;
    }

    public void setUrl(URI url) {
        this.url = url;
    }
}

