/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.ServiceXmlDeserializationException;
import microsoft.exchange.webservices.data.SuggestionQuality;
import microsoft.exchange.webservices.data.TimeSuggestion;
import microsoft.exchange.webservices.data.XmlNamespace;

public final class Suggestion
extends ComplexProperty {
    private Date date;
    private SuggestionQuality quality;
    private Collection<TimeSuggestion> timeSuggestions = new ArrayList<TimeSuggestion>();

    protected Suggestion() {
    }

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws XMLStreamException, ServiceXmlDeserializationException, Exception {
        if (reader.getLocalName().equals("Date")) {
            Date tempDate;
            SimpleDateFormat sdfin = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            this.date = tempDate = sdfin.parse(reader.readElementValue());
            return true;
        }
        if (reader.getLocalName().equals("DayQuality")) {
            this.quality = reader.readElementValue(SuggestionQuality.class);
            return true;
        }
        if (reader.getLocalName().equals("SuggestionArray")) {
            if (!reader.isEmptyElement()) {
                do {
                    reader.read();
                    if (!reader.isStartElement(XmlNamespace.Types, "Suggestion")) continue;
                    TimeSuggestion timeSuggestion = new TimeSuggestion();
                    timeSuggestion.loadFromXml(reader, reader.getLocalName());
                    this.timeSuggestions.add(timeSuggestion);
                } while (!reader.isEndElement(XmlNamespace.Types, "SuggestionArray"));
            }
            return true;
        }
        return false;
    }

    public Date getDate() {
        return this.date;
    }

    public SuggestionQuality getQuality() {
        return this.quality;
    }

    public Collection<TimeSuggestion> getTimeSuggestions() {
        return this.timeSuggestions;
    }
}

