/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import microsoft.exchange.webservices.data.AbsoluteDateTransition;
import microsoft.exchange.webservices.data.ComplexProperty;
import microsoft.exchange.webservices.data.EwsServiceXmlReader;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceXmlSerializationException;
import microsoft.exchange.webservices.data.Strings;
import microsoft.exchange.webservices.data.TimeZonePeriod;
import microsoft.exchange.webservices.data.TimeZoneTransition;
import microsoft.exchange.webservices.data.TimeZoneTransitionGroup;
import microsoft.exchange.webservices.data.XmlNamespace;

public class TimeZoneDefinition
extends ComplexProperty
implements Comparator<TimeZoneTransition> {
    private static String NoIdPrefix = "NoId_";
    protected final String StandardPeriodId = "Std";
    protected final String StandardPeriodName = "Standard";
    protected final String DaylightPeriodId = "Dlt";
    protected final String DaylightPeriodName = "Daylight";
    protected String name;
    protected String id;
    private Map<String, TimeZonePeriod> periods = new HashMap<String, TimeZonePeriod>();
    private Map<String, TimeZoneTransitionGroup> transitionGroups = new HashMap<String, TimeZoneTransitionGroup>();
    private List<TimeZoneTransition> transitions = new ArrayList<TimeZoneTransition>();

    @Override
    public int compare(TimeZoneTransition x, TimeZoneTransition y) {
        if (x == y) {
            return 0;
        }
        if (x instanceof TimeZoneTransition) {
            return -1;
        }
        if (y instanceof TimeZoneTransition) {
            return 1;
        }
        AbsoluteDateTransition firstTransition = (AbsoluteDateTransition)x;
        AbsoluteDateTransition secondTransition = (AbsoluteDateTransition)y;
        return firstTransition.getDateTime().compareTo(secondTransition.getDateTime());
    }

    protected TimeZoneDefinition() {
    }

    private TimeZoneTransitionGroup createTransitionGroupToPeriod(TimeZonePeriod timeZonePeriod) {
        TimeZoneTransition transitionToPeriod = new TimeZoneTransition(this, timeZonePeriod);
        TimeZoneTransitionGroup transitionGroup = new TimeZoneTransitionGroup(this, String.valueOf(this.transitionGroups.size()));
        transitionGroup.getTransitions().add(transitionToPeriod);
        this.transitionGroups.put(transitionGroup.getId(), transitionGroup);
        return transitionGroup;
    }

    @Override
    protected void readAttributesFromXml(EwsServiceXmlReader reader) throws Exception {
        this.name = reader.readAttributeValue("Name");
        this.id = reader.readAttributeValue("Id");
        if (this.id == null || this.id.isEmpty()) {
            String nameValue = this.getName() == null || this.getName().isEmpty() ? "" : this.getName();
            this.setId(NoIdPrefix + Math.abs(nameValue.hashCode()));
        }
    }

    @Override
    protected void writeAttributesToXml(EwsServiceXmlWriter writer) throws ServiceXmlSerializationException {
        if (writer.getService().getRequestedServerVersion() != ExchangeVersion.Exchange2007_SP1) {
            writer.writeAttributeValue("Name", this.name);
        }
        writer.writeAttributeValue("Id", this.id);
    }

    @Override
    protected boolean tryReadElementFromXml(EwsServiceXmlReader reader) throws Exception {
        if (reader.getLocalName().equals("Periods")) {
            do {
                reader.read();
                if (!reader.isStartElement(XmlNamespace.Types, "Period")) continue;
                TimeZonePeriod period = new TimeZonePeriod();
                period.loadFromXml(reader);
                this.periods.put(period.getId(), period);
            } while (!reader.isEndElement(XmlNamespace.Types, "Periods"));
            return true;
        }
        if (reader.getLocalName().equals("TransitionsGroups")) {
            do {
                reader.read();
                if (!reader.isStartElement(XmlNamespace.Types, "TransitionsGroup")) continue;
                TimeZoneTransitionGroup transitionGroup = new TimeZoneTransitionGroup(this);
                transitionGroup.loadFromXml(reader);
                this.transitionGroups.put(transitionGroup.getId(), transitionGroup);
            } while (!reader.isEndElement(XmlNamespace.Types, "TransitionsGroups"));
            return true;
        }
        if (reader.getLocalName().equals("Transitions")) {
            do {
                reader.read();
                if (!reader.isStartElement()) continue;
                TimeZoneTransition transition = TimeZoneTransition.create(this, reader.getLocalName());
                transition.loadFromXml(reader);
                this.transitions.add(transition);
            } while (!reader.isEndElement(XmlNamespace.Types, "Transitions"));
            return true;
        }
        return false;
    }

    protected void loadFromXml(EwsServiceXmlReader reader) throws Exception {
        this.loadFromXml(reader, "TimeZoneDefinition");
        Collections.sort(this.transitions, new TimeZoneDefinition());
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        if (writer.getService().getRequestedServerVersion() != ExchangeVersion.Exchange2007_SP1) {
            if (this.periods.size() > 0) {
                writer.writeStartElement(XmlNamespace.Types, "Periods");
                Iterator<TimeZonePeriod> it = this.periods.values().iterator();
                while (it.hasNext()) {
                    it.next().writeToXml(writer);
                }
                writer.writeEndElement();
            }
            if (this.transitionGroups.size() > 0) {
                writer.writeStartElement(XmlNamespace.Types, "TransitionsGroups");
                for (int i = 0; i < this.transitionGroups.size(); ++i) {
                    Object[] key = this.transitionGroups.keySet().toArray();
                    this.transitionGroups.get(key[i]).writeToXml(writer);
                }
                writer.writeEndElement();
            }
            if (this.transitions.size() > 0) {
                writer.writeStartElement(XmlNamespace.Types, "Transitions");
                for (TimeZoneTransition transition : this.transitions) {
                    transition.writeToXml(writer);
                }
                writer.writeEndElement();
            }
        }
    }

    protected void writeToXml(EwsServiceXmlWriter writer) throws Exception {
        this.writeToXml(writer, "TimeZoneDefinition");
    }

    @Override
    public void validate() throws ServiceLocalException {
        if (this.periods.size() < 1 || this.transitions.size() < 1 || this.transitionGroups.size() < 1 || this.transitionGroups.size() != this.transitions.size()) {
            throw new ServiceLocalException(Strings.InvalidOrUnsupportedTimeZoneDefinition);
        }
        if (this.transitions.get(0).getClass() != TimeZoneTransition.class) {
            throw new ServiceLocalException(Strings.InvalidOrUnsupportedTimeZoneDefinition);
        }
        for (TimeZoneTransition transition : this.transitions) {
            Class<?> transitionType = transition.getClass();
            if (transitionType != TimeZoneTransition.class && transitionType != AbsoluteDateTransition.class) {
                throw new ServiceLocalException(Strings.InvalidOrUnsupportedTimeZoneDefinition);
            }
            if (transition.getTargetGroup() != null) continue;
            throw new ServiceLocalException(Strings.InvalidOrUnsupportedTimeZoneDefinition);
        }
        for (TimeZoneTransitionGroup transitionGroup : this.transitionGroups.values()) {
            transitionGroup.validate();
        }
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    public String getId() {
        return this.id;
    }

    protected void setId(String id) {
        this.id = id;
    }

    protected Map<String, TimeZonePeriod> getPeriods() {
        return this.periods;
    }

    protected Map<String, TimeZoneTransitionGroup> getTransitionGroups() {
        return this.transitionGroups;
    }

    @Override
    protected void writeToXml(EwsServiceXmlWriter writer, String xmlElementName) throws Exception {
        this.writeToXml(writer, this.getNamespace(), xmlElementName);
    }
}

