/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.DisconnectPhoneCallRequest;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.GetPhoneCallRequest;
import microsoft.exchange.webservices.data.GetPhoneCallResponse;
import microsoft.exchange.webservices.data.ItemId;
import microsoft.exchange.webservices.data.PhoneCall;
import microsoft.exchange.webservices.data.PhoneCallId;
import microsoft.exchange.webservices.data.PlayOnPhoneRequest;
import microsoft.exchange.webservices.data.PlayOnPhoneResponse;

public final class UnifiedMessaging {
    private ExchangeService service;

    protected UnifiedMessaging(ExchangeService service) {
        this.service = service;
    }

    public PhoneCall playOnPhone(ItemId itemId, String dialString) throws Exception {
        EwsUtilities.validateParam(itemId, "itemId");
        EwsUtilities.validateParam(dialString, "dialString");
        PlayOnPhoneRequest request = new PlayOnPhoneRequest(this.service);
        request.setDialString(dialString);
        request.setItemId(itemId);
        PlayOnPhoneResponse serviceResponse = request.execute();
        PhoneCall callInformation = new PhoneCall(this.service, serviceResponse.getPhoneCallId());
        return callInformation;
    }

    protected PhoneCall getPhoneCallInformation(PhoneCallId id) throws Exception {
        GetPhoneCallRequest request = new GetPhoneCallRequest(this.service);
        request.setId(id);
        GetPhoneCallResponse response = request.execute();
        return response.getPhoneCall();
    }

    protected void disconnectPhoneCall(PhoneCallId id) throws Exception {
        DisconnectPhoneCallRequest request = new DisconnectPhoneCallRequest(this.service);
        request.setId(id);
        request.execute();
    }
}

