/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import java.util.ArrayList;
import java.util.List;
import microsoft.exchange.webservices.data.DelegateManagementRequestBase;
import microsoft.exchange.webservices.data.DelegateManagementResponse;
import microsoft.exchange.webservices.data.DelegateUser;
import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.MeetingRequestsDeliveryScope;
import microsoft.exchange.webservices.data.XmlNamespace;

public class UpdateDelegateRequest
extends DelegateManagementRequestBase<DelegateManagementResponse> {
    private List<DelegateUser> delegateUsers = new ArrayList<DelegateUser>();
    private MeetingRequestsDeliveryScope meetingRequestsDeliveryScope;

    protected UpdateDelegateRequest(ExchangeService service) throws Exception {
        super(service);
    }

    @Override
    protected void validate() throws Exception {
        super.validate();
        EwsUtilities.validateParamCollection(this.getDelegateUsers().iterator(), "DelegateUsers");
        for (DelegateUser delegateUser : this.getDelegateUsers()) {
            delegateUser.validateUpdateDelegate();
        }
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        super.writeElementsToXml(writer);
        writer.writeStartElement(XmlNamespace.Messages, "DelegateUsers");
        for (DelegateUser delegateUser : this.getDelegateUsers()) {
            delegateUser.writeToXml(writer, "DelegateUser");
        }
        writer.writeEndElement();
        if (this.getMeetingRequestsDeliveryScope() != null) {
            writer.writeElementValue(XmlNamespace.Messages, "DeliverMeetingRequests", (Object)this.getMeetingRequestsDeliveryScope());
        }
    }

    @Override
    protected String getResponseXmlElementName() {
        return "UpdateDelegateResponse";
    }

    @Override
    protected DelegateManagementResponse createResponse() {
        return new DelegateManagementResponse(true, this.delegateUsers);
    }

    @Override
    protected String getXmlElementName() {
        return "UpdateDelegate";
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2007_SP1;
    }

    public MeetingRequestsDeliveryScope getMeetingRequestsDeliveryScope() {
        return this.meetingRequestsDeliveryScope;
    }

    public void setMeetingRequestsDeliveryScope(MeetingRequestsDeliveryScope value) {
        this.meetingRequestsDeliveryScope = value;
    }

    public List<DelegateUser> getDelegateUsers() {
        return this.delegateUsers;
    }
}

