/*
 * Decompiled with CFR 0.152.
 */
package microsoft.exchange.webservices.data;

import microsoft.exchange.webservices.data.EwsServiceXmlWriter;
import microsoft.exchange.webservices.data.EwsUtilities;
import microsoft.exchange.webservices.data.ExchangeService;
import microsoft.exchange.webservices.data.ExchangeVersion;
import microsoft.exchange.webservices.data.MultiResponseServiceRequest;
import microsoft.exchange.webservices.data.ServiceErrorHandling;
import microsoft.exchange.webservices.data.ServiceLocalException;
import microsoft.exchange.webservices.data.ServiceResponse;
import microsoft.exchange.webservices.data.UserConfiguration;
import microsoft.exchange.webservices.data.XmlNamespace;

public class UpdateUserConfigurationRequest
extends MultiResponseServiceRequest<ServiceResponse> {
    protected UserConfiguration userConfiguration;

    @Override
    protected void validate() throws ServiceLocalException, Exception {
        super.validate();
        EwsUtilities.validateParam(this.userConfiguration, "userConfiguration");
    }

    @Override
    protected ServiceResponse createServiceResponse(ExchangeService service, int responseIndex) {
        return new ServiceResponse();
    }

    @Override
    protected ExchangeVersion getMinimumRequiredServerVersion() {
        return ExchangeVersion.Exchange2010;
    }

    @Override
    protected int getExpectedResponseMessageCount() {
        return 1;
    }

    @Override
    protected String getXmlElementName() {
        return "UpdateUserConfiguration";
    }

    @Override
    protected String getResponseXmlElementName() {
        return "UpdateUserConfigurationResponse";
    }

    @Override
    protected String getResponseMessageXmlElementName() {
        return "UpdateUserConfigurationResponseMessage";
    }

    @Override
    protected void writeElementsToXml(EwsServiceXmlWriter writer) throws Exception {
        this.userConfiguration.writeToXml(writer, XmlNamespace.Messages, "UserConfiguration");
    }

    protected UpdateUserConfigurationRequest(ExchangeService service) throws Exception {
        super(service, ServiceErrorHandling.ThrowOnError);
    }

    public UserConfiguration getUserConfiguration() {
        return this.userConfiguration;
    }

    public void setUserConfiguration(UserConfiguration userConfiguration) {
        this.userConfiguration = userConfiguration;
    }
}

